/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.types;

import com.impossibl.postgres.system.Identifier;
import com.impossibl.postgres.utils.guava.Preconditions;
import java.util.Objects;

public class QualifiedName {
    private String namespace;
    private String localName;

    public QualifiedName(String namespace, String localName) {
        this.namespace = Preconditions.checkNotNull(namespace);
        this.localName = Preconditions.checkNotNull(localName);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getLocalName() {
        return this.localName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QualifiedName that = (QualifiedName)o;
        return this.namespace.equals(that.namespace) && this.localName.equals(that.localName);
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.localName);
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean unqualifyCommonSchemas) {
        if (unqualifyCommonSchemas && (this.namespace.equals("pg_catalog") || this.namespace.equals("public"))) {
            return Identifier.quoteIfNeeded(this.localName);
        }
        return Identifier.quoteIfNeeded(this.namespace) + "." + Identifier.quoteIfNeeded(this.localName);
    }
}

