/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol.sasl.scram.client;

import com.impossibl.postgres.protocol.sasl.scram.ScramMechanism;
import com.impossibl.postgres.protocol.sasl.scram.ScramMechanisms;
import com.impossibl.postgres.protocol.sasl.scram.client.ScramSession;
import com.impossibl.postgres.protocol.sasl.scram.exception.ScramException;
import com.impossibl.postgres.protocol.sasl.scram.stringprep.StringPreparation;
import com.impossibl.postgres.protocol.sasl.scram.stringprep.StringPreparations;
import com.impossibl.postgres.protocol.sasl.scram.util.CryptoUtil;
import com.impossibl.postgres.protocol.sasl.scram.util.Preconditions;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ScramSessionFactory {
    public static final int DEFAULT_NONCE_LENGTH = 24;
    private final ScramMechanism scramMechanism;
    private final String channelBindMethod;
    private final boolean serverSupportsChannelBinding;
    private final StringPreparation stringPreparation;
    private final int nonceLength;
    private final SecureRandom secureRandom;

    public ScramSession start(String user) {
        String nonce = CryptoUtil.nonce(this.nonceLength, this.secureRandom);
        return new ScramSession(this.scramMechanism, this.channelBindMethod, this.serverSupportsChannelBinding, this.stringPreparation, Preconditions.checkNotNull(user, "user"), nonce);
    }

    private ScramSessionFactory(ScramMechanism scramMechanism, String channelBindMethod, boolean serverSupportsChannelBinding, StringPreparation stringPreparation, int nonceLength, SecureRandom secureRandom) {
        assert (null != scramMechanism) : "scramMechanism";
        assert (null != stringPreparation) : "stringPreparation";
        assert (null != secureRandom) : "secureRandom";
        this.scramMechanism = scramMechanism;
        this.channelBindMethod = channelBindMethod;
        this.serverSupportsChannelBinding = serverSupportsChannelBinding;
        this.stringPreparation = stringPreparation;
        this.nonceLength = nonceLength;
        this.secureRandom = secureRandom;
    }

    public static Builder builder() {
        try {
            return new Builder();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static class Builder {
        private Collection<ScramMechanism> serverAdvertisedMechanisms = Collections.emptyList();
        private String channelBindMethod = null;
        private boolean preferChannelBindingOverAlgorithmStrength = false;
        private StringPreparation stringPreparation = StringPreparations.NO_PREPARATION;
        private int nonceLength = 24;
        private SecureRandom secureRandom = SecureRandom.getInstanceStrong();

        private Builder() throws NoSuchAlgorithmException {
        }

        public Builder serverAdvertisedMechanisms(Collection<String> serverAdvertisedMechanisms) {
            Preconditions.checkNotNull(serverAdvertisedMechanisms, "serverAdvertisedMechanisms");
            this.serverAdvertisedMechanisms = serverAdvertisedMechanisms.stream().map(ScramMechanisms::byName).filter(Objects::nonNull).collect(Collectors.toList());
            return this;
        }

        public Builder preferChannelBindingMechanism(boolean preferChannelBinding) {
            this.preferChannelBindingOverAlgorithmStrength = preferChannelBinding;
            return this;
        }

        public Builder channelBindMethod(String channelBindMethod) {
            this.channelBindMethod = channelBindMethod;
            return this;
        }

        public Builder stringPreparation(StringPreparation stringPreparation) {
            this.stringPreparation = Preconditions.checkNotNull(stringPreparation, "stringPreparation");
            return this;
        }

        public Builder nonceLength(int nonceLength) {
            this.nonceLength = Preconditions.gt0(nonceLength, "nonceLength");
            return this;
        }

        public Builder secureRandomAlgorithmProvider(String algorithm, String provider) throws IllegalArgumentException {
            Preconditions.checkNotNull(algorithm, "algorithm");
            try {
                this.secureRandom = null == provider ? SecureRandom.getInstance(algorithm) : SecureRandom.getInstance(algorithm, provider);
            }
            catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                throw new IllegalArgumentException("Invalid algorithm or provider", e);
            }
            return this;
        }

        public ScramSessionFactory build() throws ScramException {
            Optional<Object> selectedChannelBindingScramMechanism = Optional.empty();
            if (this.channelBindMethod != null) {
                selectedChannelBindingScramMechanism = this.serverAdvertisedMechanisms.stream().filter(ScramMechanism::requiresChannelBinding).max(Comparator.comparingInt(ScramMechanism::algorithmKeyLength));
            }
            Optional<ScramMechanism> selectedNonChannelBindingScramMechanism = this.serverAdvertisedMechanisms.stream().filter(scramMechanism -> !scramMechanism.requiresChannelBinding()).max(Comparator.comparingInt(ScramMechanism::algorithmKeyLength));
            Optional<Object> selectedScramMechanism = selectedChannelBindingScramMechanism.isPresent() && selectedNonChannelBindingScramMechanism.isPresent() ? (this.preferChannelBindingOverAlgorithmStrength ? selectedChannelBindingScramMechanism : Stream.of((ScramMechanism)selectedChannelBindingScramMechanism.get(), selectedNonChannelBindingScramMechanism.get()).max(Comparator.comparingInt(ScramMechanism::algorithmKeyLength))) : (selectedChannelBindingScramMechanism.isPresent() ? selectedChannelBindingScramMechanism : selectedNonChannelBindingScramMechanism);
            if (!selectedScramMechanism.isPresent()) {
                String algorithmNames = this.serverAdvertisedMechanisms.stream().map(ScramMechanism::getName).collect(Collectors.joining());
                throw new ScramException(String.format("Unable to negotiate supported mechanism (advertised %s)", algorithmNames));
            }
            return new ScramSessionFactory((ScramMechanism)selectedScramMechanism.get(), this.channelBindMethod, selectedChannelBindingScramMechanism.isPresent(), this.stringPreparation, this.nonceLength, this.secureRandom);
        }
    }
}

