/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.APITracing;
import com.impossibl.postgres.jdbc.ConnectionUtil;
import com.impossibl.postgres.jdbc.JDBCSettings;
import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.protocol.v30.ServerConnectionShared;
import com.impossibl.postgres.system.SystemSettings;
import com.impossibl.postgres.system.Version;
import com.impossibl.postgres.types.SharedRegistry;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverAction;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;

public class PGDriver
implements Driver,
DriverAction {
    private static final Properties DRIVER = new Properties();
    public static final String NAME;
    public static final Version VERSION;
    public static final Logger logger;
    private static PGDriver registered;

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        SharedRegistry.Factory sharedRegistryFactory = SharedRegistry.getFactory(JDBCSettings.REGISTRY_SHARING.get(info));
        PGDirectConnection conn = ConnectionUtil.createConnection(url, info, sharedRegistryFactory);
        if (conn == null) {
            return null;
        }
        return APITracing.setupIfEnabled(conn);
    }

    @Override
    public boolean acceptsURL(String url) {
        return ConnectionUtil.parseURL(url) != null;
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) {
        return (DriverPropertyInfo[])Stream.concat(JDBCSettings.JDBC.getAllSettings().stream(), Stream.concat(SystemSettings.SYS.getAllSettings().stream(), SystemSettings.PROTO.getAllSettings().stream())).map(setting -> {
            DriverPropertyInfo pi = new DriverPropertyInfo(setting.getName(), setting.getText(info));
            pi.description = setting.getDescription();
            return pi;
        }).toArray(DriverPropertyInfo[]::new);
    }

    @Override
    public int getMajorVersion() {
        return VERSION.getMajor();
    }

    @Override
    public int getMinorVersion() {
        return VERSION.getMinor();
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger("com.impossibl.postgres");
    }

    @Override
    public void deregister() {
        PGDriver.cleanup();
    }

    public static void cleanup() {
        if (registered != null) {
            try {
                DriverManager.deregisterDriver(registered);
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "Error deregistering driver", e);
            }
        }
        ServerConnectionShared.waitForShutdown();
    }

    static {
        try {
            DRIVER.load(PGDriver.class.getClassLoader().getResourceAsStream("META-INF/pgjdbc-ng.properties"));
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        NAME = DRIVER.getProperty("name");
        VERSION = Version.parse(DRIVER.getProperty("version"));
        logger = Logger.getLogger(PGDriver.class.getName());
        try {
            registered = new PGDriver();
            DriverManager.registerDriver(registered);
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "Error registering driver", e);
        }
    }
}

