/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.PGSQLSimpleException;
import com.impossibl.postgres.utils.guava.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.util.ByteProcessor;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.Arrays;

public class PGBufferBlob
implements Blob {
    private ByteBuf buffer;

    public PGBufferBlob(ByteBuf buffer) {
        this.buffer = buffer;
    }

    private void checkFreed() throws SQLException {
        if (this.buffer == null) {
            throw new PGSQLSimpleException("Blob has been freed");
        }
    }

    private int offsetOf(long pos) throws SQLException {
        if (pos < 1L || pos > Integer.MAX_VALUE) {
            throw new PGSQLSimpleException("Blob offset is invalid");
        }
        int offset = (int)(pos - 1L);
        if (offset >= this.buffer.capacity()) {
            throw new PGSQLSimpleException("Blob offset is invalid");
        }
        return offset;
    }

    private int availableOf(int offset, int length) {
        int endOffset = offset + length;
        return length - (endOffset - this.buffer.capacity());
    }

    @Override
    public long length() throws SQLException {
        this.checkFreed();
        return this.buffer.capacity();
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        this.checkFreed();
        int offset = this.offsetOf(pos);
        int avail = this.availableOf(offset, length);
        byte[] bytes = new byte[avail];
        this.buffer.getBytes(offset, bytes);
        return bytes;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkFreed();
        return new ByteBufInputStream(this.buffer.retainedDuplicate(), true);
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        this.checkFreed();
        int bufferStart = this.offsetOf(start);
        while (bufferStart < this.buffer.capacity()) {
            int found = this.buffer.forEachByte(bufferStart, this.buffer.capacity() - bufferStart, (ByteProcessor)new ByteProcessor.IndexOfProcessor(pattern[0]));
            if (found == -1) {
                return -1L;
            }
            int avail = this.buffer.capacity() - found;
            if (avail < pattern.length) {
                return -1L;
            }
            byte[] test = new byte[pattern.length];
            this.buffer.getBytes(found, test);
            if (!Arrays.equals(pattern, test)) continue;
            return found;
        }
        return -1L;
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        long l;
        block8: {
            this.checkFreed();
            InputStream in = pattern.getBinaryStream();
            try {
                l = this.position(ByteStreams.toByteArray(in), start);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new PGSQLSimpleException("Error reading blob", e);
                }
            }
            in.close();
        }
        return l;
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        return this.setBytes(pos, bytes, 0, bytes.length);
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int bytesOff, int bytesLen) throws SQLException {
        this.checkFreed();
        if (bytesOff + bytesLen > bytes.length) {
            throw new PGSQLSimpleException("Invalid offset or length");
        }
        int offset = this.offsetOf(pos);
        int requiredLen = offset + bytes.length;
        if (requiredLen < this.buffer.capacity()) {
            this.buffer.capacity(requiredLen);
        }
        this.buffer.setBytes(offset, bytes);
        return bytes.length;
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        this.checkFreed();
        int offset = this.offsetOf(pos);
        return new ByteBufOutputStream(this.buffer.writerIndex(offset));
    }

    @Override
    public void truncate(long len) throws SQLException {
        this.checkFreed();
        this.buffer.capacity((int)len);
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        this.checkFreed();
        int offset = this.offsetOf(pos);
        int avail = this.availableOf(offset, (int)length);
        return new ByteBufInputStream(this.buffer.retainedSlice(offset, avail), true);
    }

    @Override
    public void free() {
        ReferenceCountUtil.release((Object)this.buffer);
        this.buffer = null;
    }
}

