/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.representation;

import gnu.trove.list.array.TByteArrayList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ByteFileReader {
    final char[] chars = new char[384];
    private final ReadableByteChannel channel;
    private final ByteBuffer byteBuffer;
    protected final byte[] bytes;
    private int size;
    protected int byteIndex = 0;
    ByteBuffer singletonBuffe = ByteBuffer.allocate(1);

    protected final ReadableByteChannel getChannel() {
        return this.channel;
    }

    protected final ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    protected final byte[] getBytes() {
        return this.bytes;
    }

    protected final String utf(byte[] bytes, int index, int target) {
        int i = 0;
        while (index < target) {
            int c2;
            int c;
            if ((c = bytes[index++] & 0xFF) <= 127) {
                this.chars[i++] = (char)(c & 0x7F);
                continue;
            }
            if (c > 2047) {
                c2 = bytes[index++] & 0xFF;
                int c3 = bytes[index++] & 0xFF;
                this.chars[i++] = (char)(((c & 0xF) << 12) + ((c2 & 0x3F) << 6) + (c3 & 0x3F));
                continue;
            }
            c2 = bytes[index++] & 0xFF;
            this.chars[i++] = (char)(((c & 0x1F) << 6) + (c2 & 0x3F));
        }
        return new String(this.chars, 0, i);
    }

    protected final byte[] safeBytes(int amount) throws IOException {
        byte[] result = new byte[amount];
        int has = this.size - this.byteIndex;
        if (amount >= has) {
            ReadableByteChannel c = this.channel;
            ByteBuffer bb = this.byteBuffer;
            System.arraycopy(this.bytes, this.byteIndex, result, 0, has);
            ByteBuffer bb2 = ByteBuffer.wrap(result);
            bb2.position(has);
            c.read(bb2);
            this.size = c.read(bb);
            bb.position(0);
            this.byteIndex = 0;
        } else {
            System.arraycopy(this.bytes, this.byteIndex, result, 0, amount);
            this.byteIndex += amount;
        }
        return result;
    }

    protected final int getByte() throws IOException {
        int result;
        int has = this.size - this.byteIndex;
        if (has == 0) {
            ReadableByteChannel c = this.channel;
            ByteBuffer bb = this.byteBuffer;
            this.size = c.read(bb);
            bb.position(0);
            this.byteIndex = 0;
            if (this.size == 0) {
                return -1;
            }
        }
        if ((result = this.bytes[this.byteIndex]) < 0) {
            result += 256;
        }
        ++this.byteIndex;
        return result;
    }

    protected final byte[] remaining() throws IOException {
        byte[] temp = new byte[65536];
        ByteBuffer bb = ByteBuffer.wrap(temp);
        int has = this.size - this.byteIndex;
        TByteArrayList result = new TByteArrayList(has);
        result.add(this.bytes, this.byteIndex, has);
        ReadableByteChannel c = this.channel;
        bb.position(0);
        int got = c.read(bb);
        while (got > 0) {
            result.add(temp, 0, got);
            bb.position(0);
        }
        return result.toArray();
    }

    protected final int safeInt() throws IOException {
        if (this.byteIndex >= this.size - 5) {
            int result = 0;
            ReadableByteChannel c = this.channel;
            ByteBuffer bb = this.byteBuffer;
            if (this.byteIndex == this.size) {
                this.size = c.read(bb);
                bb.position(0);
                this.byteIndex = 0;
            }
            result |= (this.bytes[this.byteIndex++] & 0xFF) << 24;
            if (this.byteIndex == this.size) {
                this.size = c.read(bb);
                bb.position(0);
                this.byteIndex = 0;
            }
            result |= (this.bytes[this.byteIndex++] & 0xFF) << 16;
            if (this.byteIndex == this.size) {
                this.size = c.read(bb);
                bb.position(0);
                this.byteIndex = 0;
            }
            result |= (this.bytes[this.byteIndex++] & 0xFF) << 8;
            if (this.byteIndex == this.size) {
                this.size = c.read(bb);
                bb.position(0);
                this.byteIndex = 0;
            }
            result |= (this.bytes[this.byteIndex++] & 0xFF) << 0;
            if (this.byteIndex == this.size) {
                this.size = c.read(bb);
                bb.position(0);
                this.byteIndex = 0;
            }
            return result;
        }
        return (this.bytes[this.byteIndex++] & 0xFF) << 24 | (this.bytes[this.byteIndex++] & 0xFF) << 16 | (this.bytes[this.byteIndex++] & 0xFF) << 8 | this.bytes[this.byteIndex++] & 0xFF;
    }

    protected final int getSize() {
        return this.size;
    }

    public ByteFileReader(ReadableByteChannel channel, int size) throws IOException {
        this.bytes = new byte[size];
        this.byteBuffer = ByteBuffer.wrap(this.bytes);
        this.channel = channel;
        this.size = channel.read(this.byteBuffer);
        this.byteBuffer.position(0);
    }
}

