/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.graph.refactoring;

import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.simantics.databoard.Files;
import org.simantics.graph.query.Path;
import org.simantics.graph.query.TransferableGraphConversion;
import org.simantics.graph.query.UriUtils;
import org.simantics.graph.refactoring.GraphRefactoringException;
import org.simantics.graph.refactoring.GraphRefactoringUtils;
import org.simantics.graph.refactoring.MappingSpecification;
import org.simantics.graph.representation.old.OldTransferableGraph1;
import org.simantics.graph.store.IdentityStore;

public class RefactoringTool {
    public static void main(String[] args) throws Exception {
        if (args.length != 3) {
            System.out.println("Usage: java " + RefactoringTool.class.getCanonicalName() + " mappingSpec input.tg ouput.tg");
        }
        RefactoringTool.refactor(new File(args[0]), new File(args[1]), new File(args[2]));
    }

    public static void refactor(File mappingSpec, File input, File output) throws IOException, GraphRefactoringException {
        if (!mappingSpec.exists()) {
            System.out.println("Mapping specification " + mappingSpec + " does not exist.");
            return;
        }
        if (!input.exists()) {
            System.out.println("Input tg " + input + " does not exist.");
            return;
        }
        MappingSpecification spec = RefactoringTool.readMappingSpec(mappingSpec);
        OldTransferableGraph1 tg = (OldTransferableGraph1)Files.readFile(input, OldTransferableGraph1.BINDING);
        boolean fixed = GraphRefactoringUtils.fixIncorrectRoot(tg.identities);
        IdentityStore idStore = TransferableGraphConversion.extractIdentities(tg);
        TIntHashSet parentsAffected = new TIntHashSet();
        GraphRefactoringUtils.refactor(idStore, spec, parentsAffected);
        tg.resourceCount = idStore.getResourceCount();
        tg.identities = idStore.toArray();
        GraphRefactoringUtils.compactify(tg, parentsAffected);
        if (fixed) {
            GraphRefactoringUtils.unfixIncorrectRoot(tg.identities);
        }
        Files.writeFile(output, OldTransferableGraph1.BINDING, tg);
    }

    private static MappingSpecification readMappingSpec(File mappingSpec) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new FileReader(mappingSpec));
        ArrayList<MappingSpecification.MappingRule> rules = new ArrayList<MappingSpecification.MappingRule>();
        while ((line = reader.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            String[] parts = line.trim().split(" ");
            if (parts.length != 2) {
                throw new IOException("Invalid mapping spec format. Every non-empty line should contain two URIs.");
            }
            Path from = UriUtils.uriToPath(parts[0]);
            Path to = UriUtils.uriToPath(parts[1]);
            rules.add(new MappingSpecification.MappingRule(from, to));
        }
        reader.close();
        return new MappingSpecification(rules);
    }
}

