/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util.binary;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.simantics.databoard.util.binary.BinaryWriteable;
import org.simantics.databoard.util.binary.UTF8;

public class ByteBufferWriteable
implements BinaryWriteable {
    ByteBuffer buf;

    public ByteBufferWriteable(ByteBuffer buf) {
        if (buf == null) {
            throw new IllegalArgumentException("null");
        }
        this.buf = buf;
    }

    @Override
    public void write(int b) {
        this.buf.put((byte)b);
    }

    @Override
    public void writeByte(int b) throws IOException {
        this.buf.put((byte)b);
    }

    @Override
    public void writeBoolean(boolean v) throws IOException {
        this.buf.put((byte)(v ? 1 : 0));
    }

    @Override
    public void writeFully(ByteBuffer src) {
        this.buf.put(src);
    }

    @Override
    public void writeFully(ByteBuffer src, int length) {
        if (src.hasArray()) {
            byte[] array = src.array();
            this.buf.put(array, src.arrayOffset() + src.position(), length);
        } else {
            int i = 0;
            while (i < length) {
                this.buf.put(src.get());
                ++i;
            }
        }
    }

    @Override
    public void write(byte[] src, int offset, int length) {
        this.buf.put(src, offset, length);
    }

    @Override
    public void write(byte[] src) {
        this.buf.put(src);
    }

    @Override
    public void writeDouble(double value) {
        this.buf.putDouble(value);
    }

    @Override
    public void writeFloat(float value) {
        this.buf.putFloat(value);
    }

    @Override
    public void writeInt(int value) {
        this.buf.putInt(value);
    }

    @Override
    public void writeLong(long value) {
        this.buf.putLong(value);
    }

    @Override
    public void writeShort(int value) {
        this.buf.putShort((short)value);
    }

    @Override
    public void writeChar(int value) {
        this.buf.putChar((char)value);
    }

    @Override
    public void writeBytes(String s) throws IOException {
        int len = s.length();
        int i = 0;
        while (i < len) {
            this.buf.put((byte)s.charAt(i));
            ++i;
        }
    }

    @Override
    public void writeChars(String s) throws IOException {
        int len = s.length();
        int i = 0;
        while (i < len) {
            char v = s.charAt(i);
            this.buf.putChar(v);
            ++i;
        }
    }

    @Override
    public void writeUTF(String s) throws IOException {
        int len = UTF8.getModifiedUTF8EncodingByteLength(s);
        this.writeShort(len);
        UTF8.writeModifiedUTF(this, s);
    }

    @Override
    public void flush() {
    }

    public long position() throws IOException {
        return this.buf.position();
    }

    public void position(long newPosition) throws IOException {
        if (newPosition >= Integer.MAX_VALUE || newPosition < 0L) {
            throw new IllegalArgumentException("index out of range");
        }
        this.buf.position((int)newPosition);
    }
}

