/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.simantics.databoard.util.binary.BinaryFile;
import org.simantics.databoard.util.binary.BinaryMemory;

public class StreamUtil {
    public static String readString(InputStream is, Charset cs) throws IOException {
        byte[] data = StreamUtil.readFully(is);
        return new String(data, cs);
    }

    public static String readString(File file, Charset cs) throws IOException {
        byte[] data = StreamUtil.readFully(file);
        return new String(data, cs);
    }

    public static byte[] readFully(InputStream is) throws IOException {
        BinaryMemory mem = new BinaryMemory(0);
        mem.put(is);
        byte[] result = new byte[(int)mem.length()];
        mem.position(0L);
        mem.readFully(result);
        return result;
    }

    public static byte[] readFully(File file) throws IOException {
        BinaryFile b = new BinaryFile(file);
        try {
            byte[] bytes = new byte[(int)b.length()];
            b.readFully(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            b.close();
        }
    }

    public static void read(InputStream is, ByteBuffer buf, int bytes) throws IOException {
        while (bytes > 0 & buf.hasRemaining()) {
            int n = is.read(buf.array(), buf.position(), bytes);
            if (n < 0) {
                throw new EOFException();
            }
            buf.position(buf.position() + n);
            bytes -= n;
        }
    }

    public static void readFully(InputStream is, ByteBuffer buf) throws IOException {
        while (buf.hasRemaining()) {
            int n = is.read(buf.array(), buf.position(), buf.remaining());
            if (n < 0) {
                throw new EOFException();
            }
            buf.position(buf.position() + n);
        }
    }

    public static void readFully(InputStream is, byte[] b) throws IOException {
        StreamUtil.readFully(is, b, 0, b.length);
    }

    public static void readFully(InputStream is, byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int n = is.read(b, off, len);
            if (n < 0) {
                throw new EOFException();
            }
            off += n;
            len -= n;
        }
    }

    public static void writeFully(byte[] data, File dst) throws IOException {
        BinaryFile out = new BinaryFile(dst);
        try {
            out.write(data);
        }
        finally {
            out.flush();
            out.close();
        }
    }
}

