/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.util;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.simantics.databoard.util.ReflectionUtils;

public class ObjectUtils {
    public static boolean objectEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        return o1.equals(o2);
    }

    public static int hashCode(Object obj) {
        return obj == null ? 0 : obj.hashCode();
    }

    public static boolean equals(Collection<?> c1, Collection<?> c2) {
        if (c1.size() != c2.size()) {
            return false;
        }
        Iterator<?> i1 = c1.iterator();
        Iterator<?> i2 = c2.iterator();
        while (i1.hasNext()) {
            if (ObjectUtils.objectEquals(i1.next(), i2.next())) continue;
            return false;
        }
        return true;
    }

    public static String toString(Collection<?> c) {
        if (c.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        int i = 0;
        for (Object o : c) {
            if (i++ > 0) {
                sb.append(", ");
            }
            sb.append(o);
        }
        sb.append("]");
        return sb.toString();
    }

    public static String printFieldsDeep(Object o) {
        HashSet<Object> visitedObjects = new HashSet<Object>();
        StringBuilder sb = new StringBuilder();
        ObjectUtils._printFieldsDeep(sb, o, "", visitedObjects);
        return sb.toString();
    }

    private static void _printFieldsDeep(StringBuilder sb, Object o, String indent, Set<Object> visitedObjects) {
        Class<?> c = o.getClass();
        sb.append(String.valueOf(c.getSimpleName()) + " (id=" + System.identityHashCode(o) + ")\n");
        if (!visitedObjects.add(o)) {
            return;
        }
        indent = String.valueOf(indent) + "  ";
        while (!c.equals(Object.class)) {
            Field[] fieldArray = ReflectionUtils.getAllFields(c);
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                block24: {
                    Field f = fieldArray[n2];
                    boolean isStatic = (f.getModifiers() & 8) == 8;
                    boolean isArray = f.getType().isArray();
                    if (!isStatic) {
                        f.setAccessible(true);
                        sb.append(String.valueOf(indent) + f.getName() + "=");
                        try {
                            Object dada = f.get(o);
                            if (dada == null) {
                                sb.append("null\n");
                                break block24;
                            }
                            if (isArray) {
                                if (dada instanceof double[]) {
                                    sb.append(String.valueOf(Arrays.toString((double[])dada)) + "\n");
                                    break block24;
                                }
                                if (dada instanceof boolean[]) {
                                    sb.append(String.valueOf(Arrays.toString((boolean[])dada)) + "\n");
                                    break block24;
                                }
                                if (dada instanceof byte[]) {
                                    sb.append(String.valueOf(Arrays.toString((byte[])dada)) + "\n");
                                    break block24;
                                }
                                if (dada instanceof char[]) {
                                    sb.append(String.valueOf(Arrays.toString((char[])dada)) + "\n");
                                    break block24;
                                }
                                if (dada instanceof float[]) {
                                    sb.append(String.valueOf(Arrays.toString((float[])dada)) + "\n");
                                    break block24;
                                }
                                if (dada instanceof int[]) {
                                    sb.append(String.valueOf(Arrays.toString((int[])dada)) + "\n");
                                    break block24;
                                }
                                if (dada instanceof long[]) {
                                    sb.append(String.valueOf(Arrays.toString((long[])dada)) + "\n");
                                    break block24;
                                }
                                if (dada instanceof short[]) {
                                    sb.append(String.valueOf(Arrays.toString((short[])dada)) + "\n");
                                    break block24;
                                }
                                sb.append(dada.getClass().getComponentType() + "[" + Array.getLength(dada) + "]\n");
                                int i = 0;
                                while (i < Array.getLength(dada)) {
                                    block25: {
                                        Object subDada = Array.get(dada, i);
                                        sb.append(String.valueOf(indent) + "  [" + i + "]=");
                                        try {
                                            if (subDada.getClass().getCanonicalName().startsWith("java")) {
                                                sb.append(subDada.toString());
                                                sb.append("\n");
                                            } else {
                                                ObjectUtils._printFieldsDeep(sb, subDada, indent, visitedObjects);
                                            }
                                        }
                                        catch (Exception e) {
                                            System.out.println("ERROR From ObjectUtils / _printfieldsDeep");
                                            if (subDada != null) break block25;
                                            System.out.println("Subdada null");
                                            System.out.println(sb.toString());
                                        }
                                    }
                                    ++i;
                                }
                                break block24;
                            }
                            if (dada.getClass().getCanonicalName().startsWith("java")) {
                                sb.append(dada.toString());
                                sb.append("\n");
                            } else {
                                ObjectUtils._printFieldsDeep(sb, dada, indent, visitedObjects);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            sb.append("?");
                        }
                        catch (IllegalAccessException e) {
                            sb.append("?");
                        }
                    }
                }
                ++n2;
            }
            c = c.getSuperclass();
        }
    }

    public static String printFields(Object o) {
        Class<?> c = o.getClass();
        StringBuilder sb = new StringBuilder();
        while (!c.equals(Object.class)) {
            Field[] fieldArray = c.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                boolean isStatic = (f.getModifiers() & 8) == 8;
                boolean isArray = f.getType().isArray();
                if (!isStatic) {
                    f.setAccessible(true);
                    if (sb.length() > 0) {
                        sb.append(", ");
                    }
                    sb.append(String.valueOf(f.getName()) + "=");
                    try {
                        Object dada = f.get(o);
                        if (dada == null) {
                            sb.append("null");
                        } else if (isArray) {
                            sb.append(ObjectUtils.toString(dada));
                        } else {
                            sb.append(dada);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        sb.append("?");
                    }
                    catch (IllegalAccessException e) {
                        sb.append("?");
                    }
                }
                ++n2;
            }
            c = c.getSuperclass();
        }
        return sb.toString();
    }

    public static String toString(Object obj) {
        if (obj instanceof Object[]) {
            return Arrays.toString((Object[])obj);
        }
        if (obj instanceof double[]) {
            return Arrays.toString((double[])obj);
        }
        if (obj instanceof boolean[]) {
            return Arrays.toString((boolean[])obj);
        }
        if (obj instanceof byte[]) {
            return Arrays.toString((byte[])obj);
        }
        if (obj instanceof char[]) {
            return Arrays.toString((char[])obj);
        }
        if (obj instanceof float[]) {
            return Arrays.toString((float[])obj);
        }
        if (obj instanceof int[]) {
            return Arrays.toString((int[])obj);
        }
        if (obj instanceof long[]) {
            return Arrays.toString((long[])obj);
        }
        if (obj instanceof short[]) {
            return Arrays.toString((short[])obj);
        }
        return obj.toString();
    }
}

