/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import java.io.IOException;
import junit.framework.TestCase;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.UnionType;

public class TestReflectionBinding
extends TestCase {
    public void testEnumeration() throws SerializationException, BindingException, IOException {
        Object dt = Datatypes.getDatatypeUnchecked(TestClass.class);
        RecordType rt = (RecordType)dt;
        UnionType ut = (UnionType)rt.getComponentType(0);
        TestReflectionBinding.assertEquals("Value1", ut.components[0].name);
        TestReflectionBinding.assertEquals("Value2", ut.components[1].name);
        TestReflectionBinding.assertEquals("Value3", ut.components[2].name);
        Object b = Bindings.getBindingUnchecked(TestClass.class);
        RecordBinding rb = (RecordBinding)b;
        UnionBinding ub = (UnionBinding)rb.componentBindings[0];
        TestReflectionBinding.assertEquals(ub.type(), ut);
        TestClass tc = new TestClass();
        tc.e0 = TestEnum.Value3;
        Serializer s = ((Binding)b).serializer();
        byte[] data = s.serialize(tc);
        TestReflectionBinding.assertEquals(1, data.length);
        tc = (TestClass)s.deserialize(data);
        TestReflectionBinding.assertEquals((Object)TestEnum.Value3, (Object)tc.e0);
    }

    public static class TestClass {
        public TestEnum e0;
    }

    public static enum TestEnum {
        Value1,
        Value2,
        Value3;

    }
}

