/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import junit.framework.TestCase;
import org.junit.Test;
import org.simantics.databoard.util.Limit;
import org.simantics.databoard.util.Range;
import org.simantics.databoard.util.RangeException;

public class TestRange
extends TestCase {
    @Test
    public void testParse() {
        TestRange.assertEquals(Limit.exclusive(5.0), Limit.exclusive(5L));
        TestRange.assertEquals(Limit.inclusive(5.0), Limit.inclusive(5L));
        TestRange.assertEquals(Limit.exclusive(5L), Limit.exclusive(5L));
        TestRange.assertEquals(Limit.inclusive(5L), Limit.inclusive(5L));
        TestRange.assertEquals(Limit.exclusive(5.0), Limit.exclusive(5.0));
        TestRange.assertEquals(Limit.inclusive(5.0), Limit.inclusive(5.0));
        TestRange.assertNotSame(Limit.inclusive(5.0), Limit.exclusive(5L));
        TestRange.assertNotSame(Limit.exclusive(5.0), Limit.inclusive(5L));
        TestRange.assertNotSame(Limit.inclusive(5.0), Limit.inclusive(6.0));
        TestRange.assertNotSame(Limit.inclusive(5L), Limit.inclusive(6L));
        try {
            Range.create(100, 50, true, true);
            TestRange.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Range.create(100.0, 50.0, true, true);
            TestRange.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            Range.create(Float.valueOf(100.0f), Float.valueOf(50.0f), true, true);
            TestRange.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        TestRange.assertEquals("[0..100]", Range.create(0, 100, true, true).toString());
        TestRange.assertEquals("[0..100)", Range.create(0, 100, true, false).toString());
        TestRange.assertEquals("(0..100]", Range.create(0, 100, false, true).toString());
        TestRange.assertEquals("[..]", new Range(Limit.nolimit(), Limit.nolimit()).toString());
        TestRange.assertEquals("[0..)", Range.create(0, null, true, false).toString());
        TestRange.assertEquals("(0..)", Range.create(0, null, false, false).toString());
        TestRange.assertEquals("(..100)", Range.create(null, 100, false, false).toString());
        TestRange.assertEquals("0", Range.create(0, 0, true, true).toString());
        TestRange.assertEquals("()", Range.create(100, 100, false, false).toString());
        TestRange.assertEquals("100", Range.create(100, 100, true, true).toString());
        TestRange.assertEquals("-100", Range.create(-100, -100, true, true).toString());
        try {
            TestRange.assertEquals(Range.valueOf("[0..100]"), Range.create(0, 100, true, true));
            TestRange.assertEquals(Range.valueOf("[0..100)"), Range.create(0, 100, true, false));
            TestRange.assertEquals(Range.valueOf("(0..100]"), Range.create(0, 100, false, true));
            TestRange.assertEquals(Range.valueOf("[..]"), new Range(Limit.nolimit(), Limit.nolimit()));
            TestRange.assertEquals(Range.valueOf("[0..)"), Range.create(0, null, true, false));
            TestRange.assertEquals(Range.valueOf("(0..)"), Range.create(0, null, false, false));
            TestRange.assertEquals(Range.valueOf("(..100)"), Range.create(null, 100, false, false));
            TestRange.assertEquals(Range.valueOf("0"), Range.create(0, 0, true, true));
            TestRange.assertEquals(Range.valueOf("()"), Range.create(100, 100, false, false));
            TestRange.assertEquals(Range.valueOf("100"), Range.create(100, 100, true, true));
            TestRange.assertEquals(Range.valueOf("[0.0E0..100.0E0]"), Range.create(0, 100, true, true));
            TestRange.assertEquals(Range.valueOf("[0.0E0..100.0E0)"), Range.create(0, 100, true, false));
            TestRange.assertEquals(Range.valueOf("(0.0E0..100.0E0]"), Range.create(0, 100, false, true));
            TestRange.assertEquals(Range.valueOf("[..]"), new Range(Limit.nolimit(), Limit.nolimit()));
            TestRange.assertEquals(Range.valueOf("[0.0E0..)"), Range.create(0, null, true, false));
            TestRange.assertEquals(Range.valueOf("(0.0E0..)"), Range.create(0, null, false, false));
            TestRange.assertEquals(Range.valueOf("(..100.0E0)"), Range.create(null, 100, false, false));
            TestRange.assertEquals(Range.valueOf("()"), Range.create(100, 100, false, false));
            TestRange.assertEquals(Range.valueOf("100.0E0"), Range.create(100, 100, true, true));
            TestRange.assertEquals(Range.valueOf("[-100..0]"), Range.create(-100, 0, true, true));
            TestRange.assertEquals(Range.valueOf("[-100..0)"), Range.create(-100, 0, true, false));
            TestRange.assertEquals(Range.valueOf("(-100..0]"), Range.create(-100, 0, false, true));
            TestRange.assertEquals(Range.valueOf("[-100..0)"), Range.create(-100, 0, true, false));
            TestRange.assertEquals(Range.valueOf("(-100..)"), Range.create(-100, null, false, false));
            TestRange.assertEquals(Range.valueOf("(..-100)"), Range.create(null, -100, false, false));
            TestRange.assertEquals(Range.valueOf("()"), Range.create(-100, -100, false, false));
            TestRange.assertEquals(Range.valueOf("-100.0"), Range.create(-100, -100, true, true));
            TestRange.assertEquals(Range.valueOf("[-100.0E0..-0.0E0]"), Range.create(-100, 0, true, true));
            TestRange.assertEquals(Range.valueOf("[..-100)"), Range.create(null, -100, false, false));
        }
        catch (RangeException e) {
            TestRange.fail(e.getMessage());
        }
        try {
            Range.valueOf("(0]");
            TestRange.fail();
        }
        catch (RangeException e) {
            // empty catch block
        }
        try {
            Range.valueOf("(0)");
            TestRange.fail();
        }
        catch (RangeException e) {
            // empty catch block
        }
        try {
            Range.valueOf("[0");
            TestRange.fail();
        }
        catch (RangeException e) {
            // empty catch block
        }
        try {
            Range.valueOf("[0]");
            TestRange.fail();
        }
        catch (RangeException e) {
            // empty catch block
        }
        try {
            Range.valueOf("[]");
            TestRange.fail();
        }
        catch (RangeException e) {
            // empty catch block
        }
        try {
            Range.valueOf("");
            TestRange.fail();
        }
        catch (RangeException e) {
            // empty catch block
        }
        try {
            Range.valueOf("{0..4]");
            TestRange.fail();
        }
        catch (RangeException e) {
            // empty catch block
        }
        try {
            Range.valueOf("[5..4]");
            TestRange.fail();
        }
        catch (IllegalArgumentException e) {
        }
        catch (RangeException e) {
            TestRange.fail();
        }
        try {
            Range.valueOf("[0,4]");
            TestRange.fail();
        }
        catch (RangeException e) {
            // empty catch block
        }
        try {
            Range.valueOf("[0 .. 4]");
            TestRange.fail();
        }
        catch (RangeException e) {
            // empty catch block
        }
        try {
            Range.valueOf("[x..4]");
            TestRange.fail();
        }
        catch (RangeException e) {
            // empty catch block
        }
        try {
            TestRange.assertFalse(Range.valueOf("[0..100]").contains(-10));
            TestRange.assertTrue(Range.valueOf("[0..100]").contains(0));
            TestRange.assertTrue(Range.valueOf("[0..100]").contains(50));
            TestRange.assertTrue(Range.valueOf("[0..100]").contains(100));
            TestRange.assertFalse(Range.valueOf("[0..100]").contains(150));
            TestRange.assertFalse(Range.valueOf("(0..100)").contains(-10));
            TestRange.assertFalse(Range.valueOf("(0..100)").contains(0));
            TestRange.assertTrue(Range.valueOf("(0..100)").contains(50));
            TestRange.assertFalse(Range.valueOf("(0..100)").contains(100));
            TestRange.assertFalse(Range.valueOf("(0..100)").contains(150));
            TestRange.assertFalse(Range.valueOf("(0..)").contains(-10));
            TestRange.assertFalse(Range.valueOf("(0..)").contains(0));
            TestRange.assertTrue(Range.valueOf("(0..)").contains(50));
            TestRange.assertTrue(Range.valueOf("(0..)").contains(100));
            TestRange.assertTrue(Range.valueOf("(0..)").contains(150));
            TestRange.assertFalse(Range.valueOf("[0..)").contains(-10));
            TestRange.assertTrue(Range.valueOf("[0..)").contains(0));
            TestRange.assertTrue(Range.valueOf("[0..)").contains(50));
            TestRange.assertTrue(Range.valueOf("[0..)").contains(100));
            TestRange.assertTrue(Range.valueOf("[0..)").contains(150));
            TestRange.assertTrue(Range.valueOf("(..100)").contains(-10));
            TestRange.assertTrue(Range.valueOf("(..100)").contains(0));
            TestRange.assertTrue(Range.valueOf("(..100)").contains(50));
            TestRange.assertFalse(Range.valueOf("(..100)").contains(100));
            TestRange.assertFalse(Range.valueOf("(..100)").contains(150));
            TestRange.assertTrue(Range.valueOf("(..100]").contains(-10));
            TestRange.assertTrue(Range.valueOf("(..100]").contains(0));
            TestRange.assertTrue(Range.valueOf("(..100]").contains(50));
            TestRange.assertTrue(Range.valueOf("(..100]").contains(100));
            TestRange.assertFalse(Range.valueOf("(..100]").contains(150));
            TestRange.assertTrue(Range.valueOf("[..]").contains(-10));
            TestRange.assertTrue(Range.valueOf("[..]").contains(0));
            TestRange.assertTrue(Range.valueOf("[..]").contains(50));
            TestRange.assertTrue(Range.valueOf("[..]").contains(100));
            TestRange.assertTrue(Range.valueOf("[..]").contains(150));
            TestRange.assertFalse(Range.valueOf("()").contains(-10));
            TestRange.assertFalse(Range.valueOf("()").contains(0));
            TestRange.assertFalse(Range.valueOf("()").contains(50));
            TestRange.assertFalse(Range.valueOf("100").contains(50));
            TestRange.assertTrue(Range.valueOf("100").contains(100));
            TestRange.assertFalse(Range.valueOf("100").contains(150));
            TestRange.assertFalse(Range.valueOf("100").contains(50));
            TestRange.assertTrue(Range.valueOf("100").contains(100));
            TestRange.assertFalse(Range.valueOf("100").contains(150));
        }
        catch (RangeException e) {
            TestRange.fail(e.getMessage());
        }
    }
}

