/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.tests;

import java.io.FileNotFoundException;
import java.io.IOException;
import junit.framework.TestCase;
import org.simantics.databoard.util.binary.BinaryMemory;
import org.simantics.databoard.util.binary.BinaryReadable;
import org.simantics.databoard.util.binary.BinaryWriteable;
import org.simantics.databoard.util.binary.RandomAccessBinary;

public class TestBinaryMemory
extends TestCase {
    public static final int ITERATIONS = 50;
    RandomAccessBinary file;

    @Override
    public void setUp() throws Exception {
        this.file = new BinaryMemory(4096);
    }

    @Override
    public void tearDown() throws Exception {
        this.file.close();
    }

    public void testInsertRemove() throws IOException {
        int i = 0;
        while (i < 0x100000) {
            this.file.writeInt(i ^ 0x53);
            ++i;
        }
        this.file.flush();
        int iterCount = 16;
        long totInsertTime = 0L;
        long totRemoveTime = 0L;
        int iter = 0;
        while (iter < iterCount) {
            this.file.position(0L);
            int i2 = 0;
            while (i2 < 0x100000) {
                TestBinaryMemory.assertEquals(i2 ^ 0x53, this.file.readInt());
                ++i2;
            }
            System.gc();
            long startTime = System.currentTimeMillis();
            this.file.position(0x200000L);
            this.file.insertBytes(262144L, RandomAccessBinary.ByteSide.Left);
            long elapsedTime = System.currentTimeMillis() - startTime;
            totInsertTime += elapsedTime;
            System.out.println("Insert 256kb in front of 2MB, time: " + elapsedTime);
            TestBinaryMemory.assertEquals(0x440000L, this.file.length());
            this.file.position(0L);
            int i3 = 0;
            while (i3 < 524288) {
                TestBinaryMemory.assertEquals(i3 ^ 0x53, this.file.readInt());
                ++i3;
            }
            this.file.position(0x240000L);
            i3 = 524288;
            while (i3 < 0x100000) {
                TestBinaryMemory.assertEquals(i3 ^ 0x53, this.file.readInt());
                ++i3;
            }
            System.gc();
            startTime = System.currentTimeMillis();
            this.file.position(0x200000L);
            this.file.removeBytes(262144L, RandomAccessBinary.ByteSide.Left);
            elapsedTime = System.currentTimeMillis() - startTime;
            totRemoveTime += elapsedTime;
            System.out.println("remove 256kb in front of 2,25MB, time: " + elapsedTime);
            TestBinaryMemory.assertEquals(0x400000L, this.file.length());
            this.file.position(0L);
            i3 = 0;
            while (i3 < 0x100000) {
                TestBinaryMemory.assertEquals(i3 ^ 0x53, this.file.readInt());
                ++i3;
            }
            ++iter;
        }
        System.out.println("Average insert time: " + totInsertTime / (long)iterCount);
        System.out.println("Average remove time: " + totRemoveTime / (long)iterCount);
    }

    public void testWriteRead() throws FileNotFoundException, IOException {
        long time4 = TestBinaryMemory.measureWrite(this.file);
        System.out.println();
        System.out.println("Write Time : " + time4);
        this.file.flush();
        this.file.position(0L);
        time4 = TestBinaryMemory.measureRead(this.file);
        System.out.println("Read Time : " + time4);
    }

    static long measureWrite(BinaryWriteable write) throws IOException {
        System.gc();
        byte[] data = new byte[1024];
        int i = 0;
        while (i < data.length) {
            data[i] = (byte)i;
            ++i;
        }
        long startTime = System.currentTimeMillis();
        int iter = 0;
        while (iter < 50) {
            if (iter % 10 == 0) {
                System.out.print(".");
            }
            int i2 = 0;
            while (i2 < 256) {
                write.write((byte)i2);
                ++i2;
            }
            i2 = 0;
            while (i2 < 256) {
                write.writeDouble(i2);
                ++i2;
            }
            i2 = 0;
            while (i2 < 256) {
                write.writeFloat(i2);
                ++i2;
            }
            i2 = 0;
            while (i2 < 256) {
                write.writeInt(i2);
                ++i2;
            }
            i2 = 0;
            while (i2 < 256) {
                write.writeShort((short)i2);
                ++i2;
            }
            write.write(data);
            ++iter;
        }
        write.flush();
        long elapsedTime = System.currentTimeMillis() - startTime;
        return elapsedTime;
    }

    static long measureRead(BinaryReadable read) throws IOException {
        System.gc();
        byte[] data = new byte[1024];
        long startTime = System.currentTimeMillis();
        int iter = 0;
        while (iter < 50) {
            if (iter % 10 == 0) {
                System.out.print(".");
            }
            int i = 0;
            while (i < 256) {
                TestBinaryMemory.assertEquals((byte)i, read.readByte());
                ++i;
            }
            i = 0;
            while (i < 256) {
                TestBinaryMemory.assertEquals((Object)i, read.readDouble());
                ++i;
            }
            i = 0;
            while (i < 256) {
                TestBinaryMemory.assertEquals(Float.valueOf(i), Float.valueOf(read.readFloat()));
                ++i;
            }
            i = 0;
            while (i < 256) {
                TestBinaryMemory.assertEquals(i, read.readInt());
                ++i;
            }
            i = 0;
            while (i < 256) {
                TestBinaryMemory.assertEquals((short)i, read.readShort());
                ++i;
            }
            read.readFully(data);
            i = 0;
            while (i < data.length) {
                TestBinaryMemory.assertEquals(data[i], (byte)i);
                ++i;
            }
            ++iter;
        }
        long elapsedTime = System.currentTimeMillis() - startTime;
        return elapsedTime;
    }
}

