/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.serialization.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.serialization.Serializer;

public class ByteSerializer
extends Serializer.NonRecursiveSerializer {
    ByteBinding binding;

    public ByteSerializer(ByteBinding binding) {
        this.binding = binding;
    }

    @Override
    public Object deserialize(DataInput in) throws IOException {
        try {
            byte value = in.readByte();
            return this.binding.create(value);
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deserializeTo(DataInput in, Object obj) throws IOException {
        try {
            this.binding.setValue(obj, in.readByte());
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void skip(DataInput in) throws IOException {
        in.skipBytes(1);
    }

    @Override
    public void serialize(DataOutput out, Object obj) throws IOException {
        try {
            byte value = this.binding.getValue_(obj);
            out.write(value);
        }
        catch (BindingException e) {
            throw new IOException(e);
        }
    }

    @Override
    public Integer getConstantSize() {
        return 1;
    }

    @Override
    public int getSize(Object obj) {
        return 1;
    }

    @Override
    public int getMinSize() {
        return 1;
    }

    public byte getByte(DataInput in) throws IOException {
        return in.readByte();
    }

    public void putByte(DataOutput out, byte x) throws IOException {
        out.writeByte(x);
    }
}

