/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.method;

import java.lang.reflect.Method;
import java.util.HashMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.factory.DatatypeConstructionException;
import org.simantics.databoard.binding.impl.OptionalBindingDefault;
import org.simantics.databoard.method.Interface;
import org.simantics.databoard.method.MethodType;
import org.simantics.databoard.method.MethodTypeBinding;
import org.simantics.databoard.method.MethodTypeDefinition;
import org.simantics.databoard.method.ObjectArrayRecordBinding;
import org.simantics.databoard.method.ObjectUnionBinding;
import org.simantics.databoard.type.Component;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.type.OptionalType;
import org.simantics.databoard.type.RecordType;
import org.simantics.databoard.type.UnionType;

public class MethodReflectionBinding {
    private HashMap<Method, MethodTypeDefinition> methodDescriptionCache = new HashMap();
    private HashMap<Method, MethodTypeBinding> methodBindingCache = new HashMap();
    private HashMap<Class<?>, MethodTypeBinding[]> interfaceBindingCache = new HashMap();
    private HashMap<Class<?>, Interface> interfaceTypeCache = new HashMap();

    public synchronized MethodTypeBinding getMethodBinding(Method m) throws BindingConstructionException {
        MethodTypeBinding mb = this.methodBindingCache.get(m);
        if (mb == null) {
            mb = this.createMethodBinding(m);
            this.methodBindingCache.put(m, mb);
        }
        return mb;
    }

    private MethodTypeBinding createMethodBinding(Method m) throws BindingConstructionException {
        try {
            MethodTypeDefinition md = this.getMethodDescription(m);
            Class<?> returnClass = m.getReturnType();
            Class<?>[] paramClasses = m.getParameterTypes();
            Class<?>[] errorClasses = m.getExceptionTypes();
            return this.createMethodBinding(md, paramClasses, returnClass, errorClasses);
        }
        catch (DatatypeConstructionException e) {
            throw new BindingConstructionException(e);
        }
    }

    private MethodTypeBinding createMethodBinding(MethodTypeDefinition md, Class<?>[] paramClasses, Class<?> returnClass, Class<?>[] errorClasses) throws BindingConstructionException {
        Object responseBinding = Bindings.getBinding(returnClass);
        ObjectArrayRecordBinding rb = new ObjectArrayRecordBinding();
        Binding[] cbs = new Binding[paramClasses.length];
        rb.setType(md.getType().getRequestType());
        int i = 0;
        while (i < paramClasses.length) {
            Class<?> paramClass = paramClasses[i];
            Object binding = Bindings.getBinding(paramClass);
            binding = new OptionalBindingDefault((Binding)binding);
            cbs[i] = binding;
            ++i;
        }
        rb.setComponentBindings(cbs);
        ObjectArrayRecordBinding requestBinding = rb;
        Datatype type = md.getType().getErrorType();
        ObjectUnionBinding ub = new ObjectUnionBinding(type, errorClasses);
        Binding[] cbs2 = new Binding[errorClasses.length];
        int i2 = 0;
        while (i2 < errorClasses.length) {
            cbs2[i2] = Bindings.getBinding(errorClasses[i2]);
            ++i2;
        }
        ub.setComponentBindings(cbs2);
        ObjectUnionBinding errorBinding = ub;
        return new MethodTypeBinding(md, (RecordBinding)requestBinding, (Binding)responseBinding, (UnionBinding)errorBinding);
    }

    public synchronized MethodTypeDefinition getMethodDescription(Method m) throws DatatypeConstructionException {
        MethodTypeDefinition md = this.methodDescriptionCache.get(m);
        if (md == null) {
            md = this.createMethodDescription(m);
            this.methodDescriptionCache.put(m, md);
        }
        return md;
    }

    public synchronized MethodType getMethodType(Method m) throws DatatypeConstructionException {
        MethodTypeDefinition md = this.methodDescriptionCache.get(m);
        if (md == null) {
            md = this.createMethodDescription(m);
            this.methodDescriptionCache.put(m, md);
        }
        return md.getType();
    }

    private MethodTypeDefinition createMethodDescription(Method m) throws DatatypeConstructionException {
        Class<?> returnClass = m.getReturnType();
        Class<?>[] paramClasses = m.getParameterTypes();
        Class<?>[] errorClasses = m.getExceptionTypes();
        Object responseType = Datatypes.getDatatype(returnClass);
        RecordType rt = new RecordType();
        Component[] components = new Component[paramClasses.length];
        rt.setReferable(false);
        int i = 0;
        while (i < paramClasses.length) {
            Object paramType = Datatypes.getDatatype(paramClasses[i]);
            paramType = new OptionalType((Datatype)paramType);
            components[i] = new Component("arg" + (i + 1), (Datatype)paramType);
            ++i;
        }
        rt.setComponents(components);
        RecordType requestType = rt;
        UnionType ut = new UnionType();
        ut.components = new Component[errorClasses.length];
        int i2 = 0;
        while (i2 < errorClasses.length) {
            ut.components[i2] = new Component(errorClasses[i2].getSimpleName(), (Datatype)Datatypes.getDatatype(errorClasses[i2]));
            ++i2;
        }
        UnionType errorType = ut;
        MethodType mt = new MethodType(requestType, (Datatype)responseType, errorType);
        MethodTypeDefinition md = new MethodTypeDefinition(m.getName(), mt);
        return md;
    }

    public synchronized MethodTypeBinding[] getInterfaceBinding(Class<?> interfaze) throws BindingConstructionException {
        MethodTypeBinding[] result = this.interfaceBindingCache.get(interfaze);
        if (result == null) {
            result = this.createInterfaceBinding(interfaze);
            this.interfaceBindingCache.put(interfaze, result);
        }
        return result;
    }

    private MethodTypeBinding[] createInterfaceBinding(Class<?> interfaze) throws BindingConstructionException {
        Method[] methods = interfaze.getMethods();
        MethodTypeBinding[] result = new MethodTypeBinding[methods.length];
        int i = 0;
        while (i < methods.length) {
            result[i] = this.getMethodBinding(methods[i]);
            ++i;
        }
        return result;
    }

    public synchronized Interface getInterfaceType(Class<?> interfaze) throws BindingConstructionException {
        Interface result = this.interfaceTypeCache.get(interfaze);
        if (result == null) {
            result = this.createInterfaceType(interfaze);
            this.interfaceTypeCache.put(interfaze, result);
        }
        return result;
    }

    private Interface createInterfaceType(Class<?> interfaze) throws BindingConstructionException {
        MethodTypeBinding[] bindings = this.getInterfaceBinding(interfaze);
        MethodTypeDefinition[] defs = new MethodTypeDefinition[bindings.length];
        int i = 0;
        while (i < bindings.length) {
            defs[i] = bindings[i].getMethodDefinition();
            ++i;
        }
        return new Interface(defs);
    }
}

