/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.example.old;

import gnu.trove.map.hash.TObjectIntHashMap;
import java.awt.geom.Rectangle2D;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Datatypes;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.error.BindingConstructionException;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.factory.DatatypeConstructionException;
import org.simantics.databoard.example.old.BindingExample;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.databoard.serialization.SerializerConstructionException;
import org.simantics.databoard.util.binary.ByteBufferReadable;
import org.simantics.databoard.util.binary.ByteBufferWriteable;

public class SerializerExample3 {
    public static void main(String[] args) throws IOException, SerializerConstructionException, SerializationException, BindingException, DatatypeConstructionException, BindingConstructionException {
        Object dataType = Datatypes.getDatatype(Rectangle2D.Double.class);
        System.out.println(dataType);
        Object reflectionBinding = Bindings.getBinding(Rectangle2D.Double.class);
        BindingExample.Rectangle2DBinding handWrittenBinding = new BindingExample.Rectangle2DBinding();
        int i = 0;
        while (i < 10) {
            System.out.println(String.valueOf(i + 1) + ": Lets measure serialization performance... (1,000,000 serialization + deserialization)");
            Serializer serializer1 = ((Binding)reflectionBinding).serializer();
            Serializer serializer2 = handWrittenBinding.serializer();
            Rectangle2DSerializer serializer3 = Rectangle2DSerializer.INSTANCE;
            long time1 = SerializerExample3.getTime(serializer1);
            long time2 = SerializerExample3.getTime(serializer2);
            long time3 = SerializerExample3.getTime(serializer3);
            System.out.println("Time of Reflection Binding + Automatic Serializer: " + time1 + " ms");
            System.out.println("Time of Hand-Written Binding + Automatic Serializer: " + time2 + " ms");
            System.out.println("Time of Hand-Written Binding + Hand-Written Serializer: " + time3 + " ms");
            System.out.println();
            ++i;
        }
    }

    static long getTime(Serializer serializer) throws IOException, SerializationException, BindingException {
        Rectangle2D.Double rect = new Rectangle2D.Double(5.0, 5.0, 100.0, 200.0);
        TObjectIntHashMap<Object> identities = new TObjectIntHashMap<Object>(0);
        int size = serializer.getSize(rect, identities);
        identities.clear();
        ByteBuffer data = ByteBuffer.allocate(size);
        ArrayList<Object> identities2 = new ArrayList<Object>();
        ByteBufferWriteable out = new ByteBufferWriteable(data);
        ByteBufferReadable in = new ByteBufferReadable(data);
        Runtime.getRuntime().gc();
        long timeAtStart = System.currentTimeMillis();
        int i = 0;
        while (i < 1000000) {
            serializer.serialize(out, identities, rect);
            data.rewind();
            serializer.deserialize(in, identities2);
            data.rewind();
            ++i;
        }
        return System.currentTimeMillis() - timeAtStart;
    }

    static class Rectangle2DSerializer
    extends Serializer.NonRecursiveSerializer {
        public static final Rectangle2DSerializer INSTANCE = new Rectangle2DSerializer();

        Rectangle2DSerializer() {
        }

        @Override
        public void serialize(DataOutput out, Object obj) throws IOException {
            Rectangle2D rect = (Rectangle2D)obj;
            out.writeDouble(rect.getX());
            out.writeDouble(rect.getY());
            out.writeDouble(rect.getWidth());
            out.writeDouble(rect.getHeight());
        }

        @Override
        public Object deserialize(DataInput in) throws IOException {
            double x = in.readDouble();
            double y = in.readDouble();
            double width = in.readDouble();
            double height = in.readDouble();
            return new Rectangle2D.Double(x, y, width, height);
        }

        @Override
        public void deserializeTo(DataInput in, Object obj) throws IOException {
            Rectangle2D.Double r = (Rectangle2D.Double)obj;
            r.x = in.readDouble();
            r.y = in.readDouble();
            r.width = in.readDouble();
            r.height = in.readDouble();
        }

        @Override
        public Integer getConstantSize() {
            return 32;
        }

        @Override
        public int getSize(Object obj) {
            return 32;
        }

        @Override
        public void skip(DataInput in) throws IOException {
            in.skipBytes(32);
        }

        @Override
        public int getMinSize() {
            return 32;
        }
    }
}

