/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.util;

import java.util.Map;
import java.util.WeakHashMap;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.ArrayBinding;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.BooleanBinding;
import org.simantics.databoard.binding.ByteBinding;
import org.simantics.databoard.binding.DoubleBinding;
import org.simantics.databoard.binding.FloatBinding;
import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.LongBinding;
import org.simantics.databoard.binding.MapBinding;
import org.simantics.databoard.binding.OptionalBinding;
import org.simantics.databoard.binding.RecordBinding;
import org.simantics.databoard.binding.StringBinding;
import org.simantics.databoard.binding.UnionBinding;
import org.simantics.databoard.binding.VariantBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.ByteType;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.type.FloatType;
import org.simantics.databoard.type.IntegerType;
import org.simantics.databoard.type.LongType;
import org.simantics.databoard.type.StringType;
import org.simantics.databoard.util.Range;

public class DefaultValueWithCache
implements Binding.Visitor<Object> {
    Map<Binding, Object> map = new WeakHashMap<Binding, Object>(1);

    @Override
    public Object visit(ArrayBinding b) {
        int min;
        Object result = this.map.get(b);
        if (result != null) {
            return result;
        }
        ArrayType at = b.type();
        Range r = at.getLength();
        int n = min = r != null ? r.getLower().getValue().intValue() : 0;
        if (min > 0) {
            Binding componentBinding = b.getComponentBinding();
            Object[] array = new Object[min];
            int i = 0;
            while (i < min) {
                array[i] = componentBinding.accept(this);
                ++i;
            }
            result = b.createUnchecked(array);
        } else {
            result = b.createUnchecked(new Object[0]);
        }
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(BooleanBinding b) {
        Object result = this.map.get(b);
        if (result != null) {
            return result;
        }
        result = b.createUnchecked(Boolean.FALSE);
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(DoubleBinding b) {
        Object result = this.map.get(b);
        if (result != null) {
            return result;
        }
        DoubleType type = b.type();
        Range range = type.getRange();
        double value = range == null ? 0.0 : range.getLower().getValue().doubleValue();
        result = b.createUnchecked(value);
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(FloatBinding b) {
        Object result = this.map.get(b);
        if (result != null) {
            return result;
        }
        FloatType type = b.type();
        Range range = type.getRange();
        float value = range == null ? 0.0f : range.getLower().getValue().floatValue();
        result = b.createUnchecked(value);
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(IntegerBinding b) {
        Object result = this.map.get(b);
        if (result != null) {
            return result;
        }
        IntegerType type = b.type();
        Range range = type.getRange();
        int value = range == null ? 0 : range.getLower().getValue().intValue();
        result = b.createUnchecked(value);
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(ByteBinding b) {
        Object result = this.map.get(b);
        if (result != null) {
            return result;
        }
        ByteType type = b.type();
        Range range = type.getRange();
        byte value = range == null ? (byte)0 : range.getLower().getValue().byteValue();
        result = b.createUnchecked(value);
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(LongBinding b) {
        Object result = this.map.get(b);
        if (result != null) {
            return result;
        }
        LongType type = b.type();
        Range range = type.getRange();
        long value = range == null ? 0L : range.getLower().getValue().longValue();
        result = b.createUnchecked(value);
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(OptionalBinding b) {
        Object result = this.map.get(b);
        if (result != null) {
            return result;
        }
        result = b.createNoValueUnchecked();
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(RecordBinding b) {
        try {
            Object result = this.map.get(b);
            if (result != null) {
                return result;
            }
            Object[] values = new Object[b.getComponentCount()];
            result = b.createPartial();
            this.map.put(b, result);
            int i = 0;
            while (i < values.length) {
                Binding cb = b.getComponentBinding(i);
                values[i] = cb.accept(this);
                ++i;
            }
            b.setComponents(result, values);
            return result;
        }
        catch (BindingException e) {
            throw new RuntimeBindingException(e);
        }
    }

    @Override
    public Object visit(StringBinding b) {
        Object result = this.map.get(b);
        if (result != null) {
            return result;
        }
        StringType st = b.type();
        result = st.getPattern() != null ? b.createUnchecked("") : b.createUnchecked("");
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(UnionBinding b) {
        Object result = this.map.get(b);
        if (result != null) {
            return result;
        }
        int tag = 0;
        Binding componentBinding = b.getComponentBinding(tag);
        Object tag0defaultValue = componentBinding.accept(this);
        result = b.createUnchecked(tag, tag0defaultValue);
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(VariantBinding b) {
        Object result = this.map.get(b);
        if (result != null) {
            return result;
        }
        Object voidBinding = Bindings.getBindingUnchecked(Void.TYPE);
        Object voidValue = null;
        result = b.createUnchecked((Binding)voidBinding, voidValue);
        this.map.put(b, result);
        return result;
    }

    @Override
    public Object visit(MapBinding b) {
        Object result = this.map.get(b);
        if (result != null) {
            return result;
        }
        result = b.createUnchecked();
        this.map.put(b, result);
        return result;
    }
}

