/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.reflection;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.simantics.databoard.annotations.ArgumentImpl;
import org.simantics.databoard.annotations.Arguments;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.reflection.ClassBindingFactory;
import org.simantics.databoard.primitives.MutableInteger;

public class BindingRequest {
    private Class<?> clazz;
    private ClassLoader cl;
    public final Annotation[] annotations;
    public final Annotation[] NO_ANNOTATIONS = new Annotation[0];
    public final String className;
    public final String signature;
    public final String descriptor;
    public BindingRequest componentRequest;
    public Binding componentBinding;
    transient int hash;

    public static BindingRequest create(Field field) {
        Annotation[] annotations = ClassBindingFactory.getFieldAnnotations(field);
        Class<?> fieldClass = field.getType();
        return new BindingRequest(fieldClass, annotations);
    }

    public BindingRequest(ClassLoader cl, String className, String classSignature, String classDescriptor, Annotation ... annotations) {
        this.className = className;
        this.cl = cl;
        this.signature = classSignature;
        this.annotations = annotations;
        this.descriptor = classDescriptor;
        this.hash = className.hashCode();
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            this.hash = 7 * this.hash + a.hashCode();
            ++n2;
        }
    }

    public BindingRequest(Class<?> clazz, Annotation ... annotations) {
        assert (annotations != null);
        this.clazz = clazz;
        Annotation[] classAnnotations = clazz.getAnnotations();
        if (classAnnotations != null && classAnnotations.length > 0) {
            this.annotations = new Annotation[classAnnotations.length + annotations.length];
            System.arraycopy(annotations, 0, this.annotations, 0, annotations.length);
            System.arraycopy(classAnnotations, 0, this.annotations, annotations.length, classAnnotations.length);
        } else {
            this.annotations = annotations;
        }
        this.className = clazz.getCanonicalName();
        this.signature = BindingRequest.getSignature(clazz);
        List<Class<?>> args = this.createArgsList();
        StringBuilder desc = new StringBuilder();
        this._buildDescriptor(desc, clazz, args, new MutableInteger(0));
        this.descriptor = desc.toString();
        this.hash = clazz.getName().hashCode();
        Annotation[] annotationArray = annotations;
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            this.hash = 7 * this.hash + a.hashCode();
            ++n2;
        }
    }

    private void _buildDescriptor(StringBuilder sb, Class<?> c, List<Class<?>> classes, MutableInteger pos) {
        int genericCount = c.getTypeParameters().length;
        int genericsLeft = classes.size() - pos.value;
        if (genericCount > 0 && genericsLeft >= genericCount) {
            sb.append('L');
            sb.append(c.getName().replaceAll("\\.", "/"));
            sb.append('<');
            int i = 0;
            while (i < genericCount) {
                Class<?> gc = classes.get(pos.value++);
                this._buildDescriptor(sb, gc, classes, pos);
                ++i;
            }
            sb.append('>');
            sb.append(';');
        } else {
            sb.append(BindingRequest.getSignature(c));
        }
    }

    public BindingRequest(Class<?> clazz, List<Annotation> annotations) {
        this(clazz, annotations.toArray(new Annotation[annotations.size()]));
    }

    public BindingRequest(Class<?> clazz, Class<?>[] parameters) {
        this(clazz, new ArgumentImpl(parameters));
    }

    public boolean hasAnnotation(Class<?> annotationClass) {
        Annotation[] annotationArray = this.annotations;
        int n = this.annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (annotationClass.equals(a.annotationType())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        Annotation[] annotationArray = this.annotations;
        int n = this.annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (annotationClass.equals(a.annotationType())) {
                return (A)a;
            }
            ++n2;
        }
        return null;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BindingRequest)) {
            return false;
        }
        BindingRequest other = (BindingRequest)obj;
        return other.descriptor.equals(this.descriptor) && Arrays.deepEquals(this.annotations, other.annotations);
    }

    public Class<?> getClazz() {
        if (this.clazz == null) {
            try {
                this.clazz = this.cl.loadClass(this.className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return this.clazz;
    }

    public Annotation[] dropAnnotations(int argumentsToDrop, Annotation ... annotationsToDrop) {
        ArrayList<Annotation> result = new ArrayList<Annotation>(this.annotations.length);
        Annotation[] annotationArray = this.annotations;
        int n = this.annotations.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                Annotation a = annotationArray[n2];
                Annotation[] annotationArray2 = annotationsToDrop;
                int n3 = annotationsToDrop.length;
                int n4 = 0;
                while (n4 < n3) {
                    Annotation b = annotationArray2[n4];
                    if (a != b) {
                        ++n4;
                        continue;
                    }
                    break block6;
                }
                if (a instanceof Arguments && argumentsToDrop > 0) {
                    Arguments c = ArgumentImpl.dropArguments((Arguments)a, argumentsToDrop);
                    if (c != null) {
                        result.add(c);
                    }
                } else {
                    result.add(a);
                }
            }
            ++n2;
        }
        Annotation[] newAnnotations = result.toArray(new Annotation[result.size()]);
        return newAnnotations;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.clazz.getName());
        if (this.annotations != null && this.annotations.length > 0) {
            sb.append('(');
            int i = 0;
            while (i < this.annotations.length) {
                Annotation a = this.annotations[i];
                if (i > 0) {
                    sb.append(", ");
                }
                sb.append(a);
                ++i;
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public static String getSignature(Class<?> clazz) {
        if (clazz == Void.TYPE) {
            return "V";
        }
        if (clazz == Boolean.TYPE) {
            return "Z";
        }
        if (clazz == Character.TYPE) {
            return "C";
        }
        if (clazz == Byte.TYPE) {
            return "B";
        }
        if (clazz == Short.TYPE) {
            return "S";
        }
        if (clazz == Integer.TYPE) {
            return "I";
        }
        if (clazz == Float.TYPE) {
            return "F";
        }
        if (clazz == Long.TYPE) {
            return "J";
        }
        if (clazz == Double.TYPE) {
            return "D";
        }
        if (clazz.isArray()) {
            return clazz.getName().replaceAll("\\.", "/");
        }
        return "L" + clazz.getName().replaceAll("\\.", "/") + ";";
    }

    List<Class<?>> createArgsList() {
        if (this.annotations == null || !this.hasAnnotation(Arguments.class)) {
            return Collections.EMPTY_LIST;
        }
        ArrayList result = new ArrayList();
        Annotation[] annotationArray = this.annotations;
        int n = this.annotations.length;
        int n2 = 0;
        while (n2 < n) {
            Annotation a = annotationArray[n2];
            if (a instanceof Arguments) {
                Arguments args = (Arguments)a;
                Class<?>[] classArray = args.value();
                int n3 = classArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Class<?> clazz = classArray[n4];
                    result.add(clazz);
                    ++n4;
                }
            }
            ++n2;
        }
        return result;
    }
}

