/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding.impl;

import org.simantics.databoard.binding.IntegerBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.primitives.UnsignedShort;
import org.simantics.databoard.type.IntegerType;

public abstract class UnsignedShortBinding
extends IntegerBinding {
    UnsignedShortBinding(IntegerType type) {
        super(type);
    }

    @Override
    public Integer getValue(Object obj) throws BindingException {
        return ((UnsignedShort)obj).toBits();
    }

    @Override
    public int getValue_(Object obj) throws BindingException {
        return ((UnsignedShort)obj).toBits();
    }

    @Override
    public String toString(Object value) throws BindingException {
        return value.toString();
    }

    public static class Immutable
    extends UnsignedShortBinding {
        public Immutable(IntegerType type) {
            super(type);
        }

        @Override
        public Object create(int value) throws BindingException {
            return UnsignedShort.fromBits(value);
        }

        @Override
        public Object create(Integer value) throws BindingException {
            return UnsignedShort.valueOf(value.intValue());
        }

        @Override
        public Object create(Number value) throws BindingException {
            return UnsignedShort.valueOf(value.longValue());
        }

        @Override
        public Object create(String value) throws BindingException {
            return UnsignedShort.valueOf(Long.valueOf(value));
        }

        @Override
        public void setValue(Object obj, Number value) throws BindingException {
            throw new BindingException("UnsignedShort is immutable class");
        }

        @Override
        public void setValue(Object obj, int value) throws BindingException {
            throw new BindingException("UnsignedShort is immutable class");
        }

        @Override
        public boolean isImmutable() {
            return true;
        }

        @Override
        public boolean isInstance(Object obj) {
            return obj instanceof UnsignedShort.Immutable;
        }
    }

    public static class Mutable
    extends UnsignedShortBinding {
        public Mutable(IntegerType type) {
            super(type);
        }

        @Override
        public Object create(int value) throws BindingException {
            return new UnsignedShort.Mutable(value);
        }

        @Override
        public Object create(Integer value) throws BindingException {
            return new UnsignedShort.Mutable(value);
        }

        @Override
        public Object create(Number value) throws BindingException {
            return UnsignedShort.Mutable.fromBits(value.intValue());
        }

        @Override
        public Object create(String value) throws BindingException {
            return new UnsignedShort.Mutable(value);
        }

        @Override
        public void setValue(Object obj, Number value) throws BindingException {
            UnsignedShort.Mutable mi = (UnsignedShort.Mutable)obj;
            mi.setBits(value.intValue());
        }

        @Override
        public void setValue(Object obj, int value) throws BindingException {
            UnsignedShort.Mutable mi = (UnsignedShort.Mutable)obj;
            mi.setBits(value);
        }

        @Override
        public boolean isImmutable() {
            return false;
        }

        @Override
        public boolean isInstance(Object obj) {
            return obj instanceof UnsignedShort.Mutable;
        }
    }
}

