/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.databoard.binding;

import java.util.IdentityHashMap;
import java.util.Set;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.NumberBinding;
import org.simantics.databoard.binding.error.BindingException;
import org.simantics.databoard.binding.error.RuntimeBindingException;
import org.simantics.databoard.type.DoubleType;
import org.simantics.databoard.util.IdentityPair;

public abstract class DoubleBinding
extends NumberBinding {
    public DoubleBinding(DoubleType type) {
        this.type = type;
    }

    @Override
    public DoubleType type() {
        return (DoubleType)this.type;
    }

    public abstract Object create(Double var1) throws BindingException;

    public abstract Object create(double var1) throws BindingException;

    @Override
    public abstract Object create(Number var1) throws BindingException;

    @Override
    public abstract Object create(String var1) throws BindingException;

    @Override
    public abstract Double getValue(Object var1) throws BindingException;

    public abstract double getValue_(Object var1) throws BindingException;

    @Override
    public abstract void setValue(Object var1, Number var2) throws BindingException;

    public abstract void setValue(Object var1, double var2) throws BindingException;

    @Override
    public abstract boolean isInstance(Object var1);

    @Override
    public void accept(Binding.Visitor1 v, Object obj) {
        v.visit(this, obj);
    }

    @Override
    public <T> T accept(Binding.Visitor<T> v) {
        return v.visit(this);
    }

    @Override
    public int deepCompare(Object o1, Object o2, Set<IdentityPair<Object, Object>> compareHistory) throws BindingException {
        double v1 = this.getValue_(o1);
        double v2 = this.getValue_(o2);
        return Double.compare(v1, v2);
    }

    @Override
    public int deepHashValue(Object value, IdentityHashMap<Object, Object> hashedObjects) throws BindingException {
        double v = this.getValue_(value);
        long bits = Double.doubleToLongBits(v);
        return (int)(bits ^ bits >>> 32);
    }

    public Object createUnchecked(double value) throws RuntimeBindingException {
        try {
            return this.create(value);
        }
        catch (BindingException e) {
            return new RuntimeBindingException(e);
        }
    }

    public Object createUnchecked(Double value) throws RuntimeBindingException {
        try {
            return this.create(value);
        }
        catch (BindingException e) {
            return new RuntimeBindingException(e);
        }
    }
}

