/*
 * Decompiled with CFR 0.152.
 */
package org.simantics;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ForkJoinPool;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.ini4j.Ini;
import org.ini4j.InvalidFileFormatException;
import org.osgi.framework.Bundle;
import org.simantics.DatabaseBaselines;
import org.simantics.OntologyImportAdvisor;
import org.simantics.PlatformException;
import org.simantics.PlatformUserAgent;
import org.simantics.Simantics;
import org.simantics.SimanticsBindings;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.Databoard;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.reflection.BindingProvider;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.db.AsyncRequestProcessor;
import org.simantics.db.Driver;
import org.simantics.db.Manager;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.SessionModel;
import org.simantics.db.UndoContext;
import org.simantics.db.VirtualGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.procedure.adapter.TransientCacheAsyncListener;
import org.simantics.db.common.processor.MergingDelayedWriteProcessor;
import org.simantics.db.common.processor.MergingGraphRequestProcessor;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.WriteResultRequest;
import org.simantics.db.common.utils.Transaction;
import org.simantics.db.exception.ClusterSetExistException;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.indexing.DatabaseIndexing;
import org.simantics.db.layer0.genericrelation.DependenciesRelation;
import org.simantics.db.layer0.genericrelation.IndexException;
import org.simantics.db.layer0.genericrelation.IndexedRelations;
import org.simantics.db.layer0.request.PossibleResource;
import org.simantics.db.layer0.util.SimanticsClipboard;
import org.simantics.db.layer0.util.SimanticsClipboardImpl;
import org.simantics.db.layer0.util.SimanticsKeys;
import org.simantics.db.layer0.util.TGTransferableGraphSource;
import org.simantics.db.layer0.variable.VariableRepository;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.SessionContext;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.db.request.Read;
import org.simantics.db.request.WriteResult;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.service.QueryControl;
import org.simantics.db.service.UndoRedoSupport;
import org.simantics.db.service.VirtualGraphSupport;
import org.simantics.db.service.XSupport;
import org.simantics.db.services.GlobalServiceInitializer;
import org.simantics.graph.db.GraphDependencyAnalyzer;
import org.simantics.graph.db.IImportAdvisor;
import org.simantics.graph.db.ImportResult;
import org.simantics.graph.db.StreamingTransferableGraphImportProcess;
import org.simantics.graph.db.TransferableGraphSource;
import org.simantics.graph.db.TransferableGraphs;
import org.simantics.graph.diff.Diff;
import org.simantics.graph.diff.TransferableGraphDelta1;
import org.simantics.internal.Activator;
import org.simantics.internal.TimedSessionCache;
import org.simantics.internal.startup.StartupExtensions;
import org.simantics.layer0.Layer0;
import org.simantics.operation.Layer0X;
import org.simantics.project.IProject;
import org.simantics.project.ProjectFeatures;
import org.simantics.project.ProjectKeys;
import org.simantics.project.Projects;
import org.simantics.project.SessionDescriptor;
import org.simantics.project.exception.ProjectException;
import org.simantics.project.features.registry.GroupReference;
import org.simantics.project.management.DatabaseManagement;
import org.simantics.project.management.GraphBundle;
import org.simantics.project.management.GraphBundleEx;
import org.simantics.project.management.GraphBundleRef;
import org.simantics.project.management.PlatformUtil;
import org.simantics.project.management.ServerManager;
import org.simantics.project.management.ServerManagerFactory;
import org.simantics.project.management.WorkspaceUtil;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.utils.FileUtils;
import org.simantics.utils.datastructures.Pair;
import org.simantics.utils.strings.EString;
import org.simantics.utils.threads.ExecutorWorker;
import org.simantics.utils.threads.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimanticsPlatform
implements LifecycleSupport.LifecycleListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimanticsPlatform.class);
    public static final SimanticsPlatform INSTANCE = new SimanticsPlatform();
    public boolean running;
    private String currentDatabaseDriver;
    public Session session;
    private Driver.Management databasebManagement;
    public SessionContext sessionContext;
    public String projectURI;
    public String projectName;
    public Resource projectResource;
    public SimanticsBindings simanticsBindings;
    public Thread mainThread;
    private Thread shutdownHook = new Thread(){

        @Override
        public void run() {
            try {
                LOGGER.warn("Simantics platform was not properly shut down. Executing safety shutdown hook.");
                SimanticsPlatform.this.shutdown(null, false);
            }
            catch (PlatformException e) {
                LOGGER.error("Simantics Platform shutdown hook execution failed.", (Throwable)e);
                SimanticsPlatform.this.log.log((IStatus)new Status(4, "org.simantics", "Simantics Platform shutdown hook execution failed.", (Throwable)e));
            }
        }
    };
    private IProject project;
    protected ILog log = Platform.getLog((Bundle)Activator.getBundleContext().getBundle());

    public SimanticsPlatform() {
        this.mainThread = Thread.currentThread();
    }

    public String getApplicationClientId() {
        IProduct product = Platform.getProduct();
        if (product == null) {
            return "noProduct";
        }
        String application = product.getApplication();
        return application != null ? application : UUID.randomUUID().toString();
    }

    private SessionDescriptor setupDatabase(String databaseDriverId, IProgressMonitor progressMonitor, RecoveryPolicy workspacePolicy, PlatformUserAgent userAgent) throws PlatformException {
        ServerManager serverManager;
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        Path workspaceLocation = Platform.getLocation().toFile().toPath();
        Path dbLocation = this.dbLocation();
        Path dbIniPath = workspaceLocation.resolve("db.ini");
        try {
            Ini dbIni = this.loadOrCreateDatabaseIni(dbIniPath, databaseDriverId);
            databaseDriverId = dbIni.get((Object)"driver", (Object)"id");
            serverManager = ServerManagerFactory.create((String)databaseDriverId, (String)dbLocation.toAbsolutePath().toString());
        }
        catch (IOException | DatabaseException e) {
            throw new PlatformException("Failed to initialize database ServerManager with driver " + databaseDriverId, e);
        }
        progressMonitor.beginTask("Setting up Simantics Database", 100);
        progressMonitor.setTaskName("Asserting Database is installed.");
        String msg = "Failed to initialize Simantics database.";
        try {
            this.log.log((IStatus)new Status(1, "org.simantics", "Initializing database at " + String.valueOf(dbLocation) + " with driver " + databaseDriverId));
            progressMonitor.setTaskName("Creating database at " + String.valueOf(dbLocation));
            this.databasebManagement = serverManager.getManagement(dbLocation.toFile());
            this.databasebManagement.create();
            this.currentDatabaseDriver = databaseDriverId;
            SessionDescriptor sessionDescriptor = serverManager.createDatabase(dbLocation.toFile());
            return sessionDescriptor;
        }
        catch (DatabaseException e) {
            throw new PlatformException(msg, e);
        }
        catch (Throwable e) {
            throw new PlatformException(msg, e);
        }
        finally {
            progressMonitor.worked(20);
        }
    }

    public void synchronizeOntologies(IProgressMonitor progressMonitor, OntologyRecoveryPolicy ontologyPolicy, boolean requireSynchronize) throws PlatformException {
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)100);
        if (Boolean.parseBoolean(System.getProperty("org.simantics.platform.compileDynamicOntologies", "false"))) {
            monitor.setTaskName("Compile dynamic ontologies");
            PlatformUtil.compileAllDynamicOntologies();
        }
        String message = "Asserting all ontologies are installed";
        LOGGER.info(message);
        monitor.setTaskName(message);
        DatabaseManagement mgmt = new DatabaseManagement();
        HashMap<GraphBundleRef, GraphBundleEx> platformTGs = new HashMap<GraphBundleRef, GraphBundleEx>();
        try {
            message = "find installed bundles from database";
            monitor.subTask(message);
            LOGGER.info(message);
            HashMap<GraphBundleRef, GraphBundleEx> installedTGs = new HashMap<GraphBundleRef, GraphBundleEx>();
            for (GraphBundle b : (Set)this.session.syncRequest(mgmt.GraphBundleQuery)) {
                installedTGs.put(GraphBundleRef.of((GraphBundle)b), GraphBundleEx.extend((GraphBundle)b));
            }
            if (!requireSynchronize && installedTGs.size() > 1 && !Platform.inDevelopmentMode()) {
                return;
            }
            message = "load all transferable graphs from platform";
            monitor.subTask(message);
            LOGGER.info(message);
            Collection tgs = PlatformUtil.getAllGraphs();
            message = "extend bundles to compile versions";
            monitor.subTask(message);
            LOGGER.info(message);
            for (GraphBundle b : tgs) {
                GraphBundleEx gbe = GraphBundleEx.extend((GraphBundle)b);
                gbe.build();
                platformTGs.put(GraphBundleRef.of((GraphBundle)b), gbe);
            }
            message = "check bundle reinstallation demand";
            monitor.subTask(message);
            LOGGER.info(message);
            ArrayList<GraphBundleEx> installTGs = new ArrayList<GraphBundleEx>();
            TreeMap<Object, GraphBundleEx> reinstallTGs = new TreeMap<Object, GraphBundleEx>();
            for (Map.Entry e : platformTGs.entrySet()) {
                boolean platformBundleIsNewer;
                GraphBundleRef graphBundleRef = (GraphBundleRef)e.getKey();
                GraphBundleEx platformBundle = (GraphBundleEx)e.getValue();
                GraphBundleEx existingBundle = (GraphBundleEx)installedTGs.get(graphBundleRef);
                if (existingBundle == null) {
                    installTGs.add(platformBundle);
                    continue;
                }
                boolean bl = platformBundleIsNewer = existingBundle.getVersion().compareTo((Object)platformBundle.getVersion()) < 0;
                if (!platformBundleIsNewer || platformBundle.getHashcode() == existingBundle.getHashcode()) continue;
                reinstallTGs.put(platformBundle, existingBundle);
            }
            if (!installTGs.isEmpty() || !reinstallTGs.isEmpty()) {
                ((XSupport)this.session.getService(XSupport.class)).setServiceMode(true, true);
                if (ontologyPolicy == OntologyRecoveryPolicy.ThrowError || ontologyPolicy == OntologyRecoveryPolicy.Bypass) {
                    StringBuilder sb = new StringBuilder("The following graphs are not installed in the database: ");
                    if (!installTGs.isEmpty()) {
                        int i = 0;
                        for (GraphBundleEx graphBundleEx : installTGs) {
                            if (i > 0) {
                                sb.append(", ");
                            }
                            ++i;
                            sb.append(graphBundleEx.toString());
                        }
                        sb.append(" is missing from the database.\n");
                    }
                    if (!reinstallTGs.isEmpty()) {
                        int i = 0;
                        for (Map.Entry entry : reinstallTGs.entrySet()) {
                            if (i > 0) {
                                sb.append(", ");
                            }
                            ++i;
                            sb.append(((GraphBundleEx)entry.getKey()).toString());
                        }
                        sb.append(" Database/Platform Bundle version mismatch.\n");
                    }
                    sb.append("Hint: Use -fixErrors to install the graphs.");
                    if (ontologyPolicy == OntologyRecoveryPolicy.ThrowError) {
                        throw new PlatformException(sb.toString());
                    }
                    this.log.log((IStatus)new Status(2, "org.simantics", sb.toString()));
                }
                if (ontologyPolicy == OntologyRecoveryPolicy.ReinstallDatabase) {
                    this.log.log((IStatus)new Status(1, "org.simantics", "Reinstalling the database."));
                    throw new PlatformException("Reinstalling Database, NOT IMPLEMENTED");
                }
                boolean serviceModeEntered = false;
                if (ontologyPolicy == OntologyRecoveryPolicy.Merge) {
                    StringBuilder sb;
                    message = "Merging ontology changes";
                    monitor.subTask(message);
                    LOGGER.info(message);
                    GraphDependencyAnalyzer analyzer = new GraphDependencyAnalyzer();
                    for (GraphBundle graphBundle : installTGs) {
                        analyzer.addGraph((Comparable)graphBundle, graphBundle.getGraph());
                    }
                    for (GraphBundle graphBundle : reinstallTGs.keySet()) {
                        analyzer.addGraph((Comparable)graphBundle, graphBundle.getGraph());
                    }
                    if (!analyzer.analyzeDependency()) {
                        Collection collection = analyzer.getConflicts();
                        sb = new StringBuilder();
                        for (Pair problem : collection) {
                            sb.append("Conflict with " + String.valueOf(problem.first) + " and " + String.valueOf(problem.second) + ".\n");
                        }
                        throw new PlatformException(sb.toString());
                    }
                    if (!((Boolean)this.session.syncRequest(analyzer.queryExternalDependenciesSatisfied)).booleanValue()) {
                        ArrayList arrayList = analyzer.getUnsatisfiedDependencies();
                        sb = new StringBuilder();
                        for (GraphDependencyAnalyzer.IdentityNode dep : arrayList) {
                            sb.append("Unsatisfied Dependency " + String.valueOf(dep) + ". Required by\n");
                            for (GraphDependencyAnalyzer.IU iu : GraphDependencyAnalyzer.toCollection((GraphDependencyAnalyzer.IUList)dep.getRequires())) {
                                sb.append("    " + ((GraphBundle)iu.getId()).getId() + "\n");
                            }
                        }
                        throw new PlatformException(sb.toString());
                    }
                    message = "Analyzed graph bundles";
                    monitor.subTask(message);
                    LOGGER.info(message);
                    List list = analyzer.getSortedGraphs();
                    if (!list.isEmpty()) {
                        this.session.syncRequest(graph -> {
                            try {
                                graph.newClusterSet(graph.getRootLibrary());
                            }
                            catch (ClusterSetExistException clusterSetExistException) {}
                            graph.setClusterSet4NewResource(graph.getRootLibrary());
                            graph.flushCluster();
                        });
                        boolean mergedOntologies = false;
                        for (GraphBundle tg : list) {
                            OntologyImportAdvisor advisor = new OntologyImportAdvisor(tg, mgmt);
                            GraphBundle oldTG = (GraphBundle)reinstallTGs.get(tg);
                            boolean createImmutable = tg.getImmutable();
                            if (oldTG == null) {
                                ((XSupport)this.session.getService(XSupport.class)).setServiceMode(true, createImmutable);
                                if (!serviceModeEntered) {
                                    serviceModeEntered = true;
                                    ((QueryControl)this.session.getService(QueryControl.class)).flush();
                                }
                                this.log.log((IStatus)new Status(1, "org.simantics", "Installing " + tg.toString() + " - " + tg.getName()));
                                ImportResult result = TransferableGraphs.importGraph1((Session)this.session, null, (TransferableGraphSource)new TGTransferableGraphSource(tg.getGraph()), (IImportAdvisor)advisor, null, (Boolean)false, (Boolean)StreamingTransferableGraphImportProcess.failOnMissingEntities(), (Boolean)false);
                                if (result.hasMissingExternals()) {
                                    this.log.log((IStatus)new Status(4, "org.simantics", "Import of " + tg.toString() + " was missing the following external entities:\n" + EString.implode((Collection)result.missingExternals())));
                                    continue;
                                }
                                this.session.syncRequest(graph -> ((XSupport)this.session.getService(XSupport.class)).invalidateRequests(graph, result.resolvedExternals((RequestProcessor)this.session)));
                                continue;
                            }
                            if (!createImmutable) continue;
                            Transaction.startTransaction((AsyncRequestProcessor)this.session, (boolean)false);
                            TransferableGraphDelta1 delta = new Diff(oldTG.getGraph(), tg.getGraph()).diff();
                            long[] oldResources = oldTG.getResourceArray();
                            boolean changes = TransferableGraphs.hasChanges((ReadGraph)Transaction.readGraph(), (long[])oldResources, (TransferableGraphDelta1)delta);
                            Transaction.endTransaction();
                            if (!changes) continue;
                            this.log.log((IStatus)new Status(1, "org.simantics", "Merging new version of " + tg.toString()));
                            Transaction.startTransaction((AsyncRequestProcessor)this.session, (boolean)true);
                            try {
                                try {
                                    long[] resourceArray = TransferableGraphs.applyDelta((WriteGraph)Transaction.writeGraph(), (long[])oldResources, (TransferableGraphDelta1)delta);
                                    tg.setResourceArray(resourceArray);
                                    mgmt.setGraphBundleEntry(tg);
                                    Transaction.commit();
                                    mergedOntologies = true;
                                }
                                catch (Throwable t) {
                                    throw new PlatformException(t);
                                }
                            }
                            finally {
                                Transaction.endTransaction();
                            }
                            this.session.syncRequest(graph -> {
                                QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
                                qc.flush((ReadGraph)graph);
                            });
                        }
                        this.session.syncRequest(graph -> {
                            graph.setClusterSet4NewResource(graph.getRootLibrary());
                            graph.flushCluster();
                        });
                        if (mergedOntologies) {
                            DatabaseIndexing.deleteAllIndexes();
                        }
                    }
                }
                ((XSupport)this.session.getService(XSupport.class)).setServiceMode(false, false);
                if (serviceModeEntered) {
                    ((QueryControl)this.session.getService(QueryControl.class)).flush();
                }
            }
            message = "Ontologies synchronized";
            monitor.subTask(message);
            LOGGER.info(message);
            monitor.worked(100);
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
        catch (DatabaseException e) {
            throw new PlatformException(e);
        }
    }

    public boolean assertConfiguration(IProgressMonitor progressMonitor, RecoveryPolicy workspacePolicy) throws PlatformException {
        if (progressMonitor == null) {
            progressMonitor = new NullProgressMonitor();
        }
        File workspaceLocation = Platform.getLocation().toFile();
        boolean installProject = false;
        progressMonitor.setTaskName("Asserting simantics.cfg is installed");
        try {
            Properties properties;
            File propertyFile = new File(workspaceLocation, "simantics.cfg");
            try {
                properties = WorkspaceUtil.readProperties((File)propertyFile);
            }
            catch (IOException iOException) {
                if (workspacePolicy == RecoveryPolicy.ThrowError) {
                    throw new PlatformException("Could not load " + String.valueOf(propertyFile));
                }
                properties = new Properties();
                properties.setProperty("project_uri", "http://Projects/Development%20Project");
                properties.setProperty("project_name", "Development Project");
                WorkspaceUtil.writeProperties((File)propertyFile, (Properties)properties);
                installProject |= true;
            }
            this.projectURI = properties.getProperty("project_uri");
            this.projectName = properties.getProperty("project_name");
            progressMonitor.worked(10);
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
        return installProject;
    }

    public boolean assertProject(IProgressMonitor progressMonitor, RecoveryPolicy workspacePolicy, boolean installProject) throws PlatformException {
        SubMonitor monitor;
        block8: {
            monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)10);
            DatabaseManagement mgmt = new DatabaseManagement();
            monitor.setTaskName("Asserting project resource exists in the database");
            try {
                this.projectResource = (Resource)this.session.syncRequest((Read)new PossibleResource(this.projectURI));
                if (this.projectResource != null) break block8;
                if (workspacePolicy == RecoveryPolicy.ThrowError) {
                    throw new PlatformException("Project Resource " + this.projectURI + " is not found in the database.");
                }
                try {
                    Transaction.startTransaction((AsyncRequestProcessor)this.session, (boolean)true);
                    try {
                        ((XSupport)this.session.getService(XSupport.class)).setServiceMode(true, false);
                        ArrayList empty = new ArrayList();
                        this.projectResource = mgmt.createProject(this.projectName, empty);
                        installProject |= true;
                        ((XSupport)this.session.getService(XSupport.class)).setServiceMode(false, false);
                        Transaction.commit();
                    }
                    finally {
                        Transaction.endTransaction();
                    }
                    ((QueryControl)this.session.getService(QueryControl.class)).flush();
                }
                catch (DatabaseException e) {
                    throw new PlatformException("Failed to create " + this.projectURI, e);
                }
            }
            catch (DatabaseException e) {
                throw new PlatformException("Failed to create " + this.projectURI, e);
            }
        }
        monitor.worked(10);
        return installProject;
    }

    public void updateInstalledGroups(IProgressMonitor progressMonitor, boolean installProject) throws PlatformException {
        if (installProject) {
            progressMonitor.setTaskName("Install all features");
            Set publishedFeatureGroups = ProjectFeatures.getInstallGroupsOfPublishedFeatures();
            Collection groupsWithoutVersion = GroupReference.stripVersions((Collection)publishedFeatureGroups);
            try {
                this.session.syncRequest(graph -> {
                    Resource resource = Projects.setProjectInstalledGroups((WriteGraph)graph, (Resource)this.projectResource, (Collection)groupsWithoutVersion);
                });
            }
            catch (DatabaseException ae) {
                throw new PlatformException("Failed to install features", ae);
            }
            progressMonitor.worked(10);
        }
    }

    public void assertSessionModel(IProgressMonitor progressMonitor) throws PlatformException {
        Properties properties = (Properties)this.session.getService(Properties.class);
        final String clientId = properties.getProperty("clientId");
        try {
            VirtualGraphSupport support = (VirtualGraphSupport)this.session.getService(VirtualGraphSupport.class);
            VirtualGraph activations = support.getWorkspacePersistent("activations");
            Resource sessionModel = (Resource)this.session.syncRequest((Read)new Read<Resource>(){

                public Resource perform(ReadGraph graph) throws DatabaseException {
                    Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                    for (Resource sessionModel : (Collection)graph.syncRequest((Read)new ObjectsWithType(graph.getRootLibrary(), L0X.HasSession, L0X.Session))) {
                        String id = (String)graph.getPossibleRelatedValue(sessionModel, L0X.Session_HasClientId);
                        if (id == null || !id.equals(clientId)) continue;
                        return sessionModel;
                    }
                    return null;
                }
            }, (AsyncProcedure)TransientCacheAsyncListener.instance());
            if (sessionModel == null) {
                sessionModel = (Resource)this.session.syncRequest((WriteResult)new WriteResultRequest<Resource>(activations){

                    public Resource perform(WriteGraph graph) throws DatabaseException {
                        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
                        Layer0X L0X = Layer0X.getInstance((ReadGraph)graph);
                        Resource session = graph.newResource();
                        graph.claim(session, L0.InstanceOf, null, L0X.Session);
                        graph.claim(session, L0X.Session_HasUser, null, graph.getResource("http://Users/AdminUser"));
                        graph.addLiteral(session, L0X.Session_HasClientId, L0X.Session_HasClientId_Inverse, (Object)clientId, (Binding)Bindings.STRING);
                        graph.claim(graph.getRootLibrary(), L0X.HasSession, session);
                        return session;
                    }
                });
            }
            this.session.registerService(SessionModel.class, (Object)new PlatformSessionModel(sessionModel));
        }
        catch (DatabaseException e) {
            throw new PlatformException(e);
        }
    }

    public void resetDatabase(IProgressMonitor monitor) throws PlatformException {
        File dbLocation = this.dbLocation().toFile();
        if (!dbLocation.exists()) {
            return;
        }
        try {
            Driver driver = Manager.getDriver((String)"acorn");
            Driver.Management management = driver.getManagement(dbLocation.getAbsolutePath(), null);
            management.delete();
        }
        catch (DatabaseException e) {
            throw new PlatformException("Failed to remove database at " + dbLocation.getAbsolutePath(), e);
        }
        IOException t = null;
        int i = 0;
        while (i < 10) {
            try {
                FileUtils.deleteAll((File)dbLocation);
                t = null;
                break;
            }
            catch (IOException e) {
                t = e;
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
                ++i;
            }
        }
        if (t != null) {
            throw new PlatformException("Failed to remove database folder at " + dbLocation.getAbsolutePath(), t);
        }
    }

    public void resetWorkspace(IProgressMonitor monitor, ArrayList<String> fileFilter) throws PlatformException, IllegalStateException, IOException {
        File file = Platform.getLocation().toFile();
        if (fileFilter != null) {
            FileUtils.deleteAllWithFilter((File)file, fileFilter);
        }
        this.resetDatabase(monitor);
    }

    private static Path tryGetInstallLocation() {
        Location l = Platform.getInstallLocation();
        return l == null ? null : new File(l.getURL().getPath()).toPath();
    }

    public Path databaseExists() {
        Path dbLocation = this.dbLocation();
        if (Files.exists(dbLocation, new LinkOption[0])) {
            return dbLocation;
        }
        return null;
    }

    public Path dbLocation() {
        Path workspaceLocation = Platform.getLocation().toFile().toPath();
        return workspaceLocation.resolve("db");
    }

    public synchronized SessionContext startUp(String databaseDriverId, IProgressMonitor progressMonitor, RecoveryPolicy workspacePolicy, OntologyRecoveryPolicy ontologyPolicy, boolean requireSynchronize, PlatformUserAgent userAgent) throws PlatformException {
        assert (!this.running);
        LOGGER.info("Beginning of SimanticsPlatform.startUp");
        SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)1000);
        if ("true".equals(System.getProperty("org.simantics.dumpBundleState"))) {
            this.dumpPlatformBundleState();
        }
        StartupExtensions.consultStartupExtensions();
        LOGGER.info("Consulted platform pre-startup extensions");
        LOGGER.info("Warming up SCL-compiler with StandardLibrary");
        ForkJoinPool.commonPool().submit(() -> {
            Failable module = SCLOsgi.MODULE_REPOSITORY.getModule("StandardLibrary");
            LOGGER.info("StandardLibrary compiled {}", (Object)module);
        });
        Simantics.clearTemporaryDirectory();
        LOGGER.info("Cleared temporary directory");
        VariableRepository.clear();
        DatabaseBaselines.handleBaselineDatabase(SimanticsPlatform.tryGetInstallLocation(), this.databaseExists() != null);
        SessionDescriptor sessionDescriptor = this.setupDatabase(databaseDriverId, (IProgressMonitor)monitor.newChild(200, 0), workspacePolicy, userAgent);
        this.session = sessionDescriptor.getSession();
        LOGGER.info("Database setup complete");
        XSupport support = (XSupport)this.session.getService(XSupport.class);
        if (support.rolledback()) {
            try {
                DatabaseIndexing.deleteAllIndexes();
            }
            catch (IOException e) {
                throw new PlatformException(e);
            }
        }
        this.synchronizeOntologies((IProgressMonitor)monitor.newChild(400, 0), ontologyPolicy, requireSynchronize);
        boolean installProject = this.assertConfiguration((IProgressMonitor)monitor.newChild(25, 0), workspacePolicy);
        installProject = this.assertProject((IProgressMonitor)monitor.newChild(25, 0), workspacePolicy, installProject);
        this.updateInstalledGroups((IProgressMonitor)monitor.newChild(25), true);
        LOGGER.info("Installed all features into project");
        this.assertSessionModel((IProgressMonitor)monitor.newChild(25, 0));
        ((XSupport)this.session.getService(XSupport.class)).setServiceMode(false, false);
        try {
            String message = "Flush query cache";
            monitor.setTaskName(message);
            LOGGER.info(message);
            this.session.syncRequest(graph -> {
                QueryControl qc = (QueryControl)graph.getService(QueryControl.class);
                qc.flush((ReadGraph)graph);
            });
        }
        catch (DatabaseException e) {
            LOGGER.error("Flushing queries failed.", (Throwable)e);
        }
        boolean loadProject = true;
        try {
            String message = "Open database session";
            monitor.setTaskName(message);
            LOGGER.info(message);
            this.sessionContext = INSTANCE.createSessionContext(true);
            this.sessionContext.setHint(SimanticsKeys.KEY_PROJECT, (Object)SimanticsPlatform.INSTANCE.projectResource);
            Simantics.setSessionContext((ISessionContext)this.sessionContext);
            message = "Put ResourceBinding that throws an exception to General Bindings";
            LOGGER.info(message);
            this.simanticsBindings = new SimanticsBindings();
            Bindings.classBindingFactory.addFactory((BindingProvider)this.simanticsBindings);
            Session session = this.sessionContext.getSession();
            session.registerService(Databoard.class, (Object)Bindings.databoard);
            message = "Register datatype bindings";
            LOGGER.info(message);
            Bindings.defaultBindingFactory.getRepository().put(RGB.Integer.BINDING.type(), RGB.Integer.BINDING);
            Bindings.defaultBindingFactory.getRepository().put(Font.BINDING.type(), Font.BINDING);
            if (support.rolledback() || sessionDescriptor.isFreshDatabase()) {
                message = "Rebuilding all indexes";
                LOGGER.info(message);
                monitor.setTaskName(message);
                try {
                    ((IndexedRelations)session.getService(IndexedRelations.class)).fullRebuild((IProgressMonitor)monitor.newChild(100), (RequestProcessor)session);
                }
                catch (IndexException e) {
                    LOGGER.error("Failed to re-build all indexes", (Throwable)e);
                }
            } else {
                monitor.worked(100);
            }
            if (loadProject) {
                message = "Load project";
                monitor.setTaskName(message);
                LOGGER.info(message);
                this.project = Projects.loadProject((RequestProcessor)this.sessionContext.getSession(), (Resource)SimanticsPlatform.INSTANCE.projectResource);
                this.sessionContext.setHint(ProjectKeys.KEY_PROJECT, (Object)this.project);
                monitor.worked(100);
                message = "Loading projects complete";
                LOGGER.info(message);
                message = "Activate project";
                monitor.setTaskName(message);
                LOGGER.info(message);
                this.project.activate();
                monitor.worked(100);
                LOGGER.info("Project activated");
            }
        }
        catch (DatabaseException e) {
            LOGGER.error("Platform startup failed.", (Throwable)e);
            throw new PlatformException(e);
        }
        catch (ProjectException e) {
            boolean hasStackTrace;
            boolean bl = hasStackTrace = e.getStackTrace().length > 0;
            if (!hasStackTrace) {
                throw new PlatformException(e.getMessage(), hasStackTrace);
            }
            throw new PlatformException(e, hasStackTrace);
        }
        this.running = true;
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        INSTANCE.discardSessionUndoHistory();
        LOGGER.info("Discarded session undo history");
        return this.sessionContext;
    }

    public void registerServices(SessionContext context) {
        new GlobalServiceInitializer().initialize(this.session);
        this.session.registerService(MergingGraphRequestProcessor.class, (Object)new MergingGraphRequestProcessor("SessionService", (AsyncRequestProcessor)this.session, 20L));
        this.session.registerService(MergingDelayedWriteProcessor.class, (Object)new MergingDelayedWriteProcessor((AsyncRequestProcessor)this.session, 20L));
    }

    public SessionContext createSessionContext(boolean init) throws PlatformException {
        try {
            SessionContext sessionContext = SessionContext.create((Session)this.session, (boolean)init);
            String message = "Session context created";
            LOGGER.info(message);
            if (init) {
                this.registerServices(sessionContext);
                message = "Session services registered";
                LOGGER.info(message);
            }
            return sessionContext;
        }
        catch (DatabaseException e) {
            throw new PlatformException(e);
        }
    }

    public synchronized void shutdown(IProgressMonitor progressMonitor) throws PlatformException {
        this.shutdown(progressMonitor, true);
    }

    public synchronized void shutdown(IProgressMonitor progressMonitor, boolean clearTemporaryFiles) throws PlatformException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)100);
        PlatformException platformException = null;
        try {
            progress.subTask("Close Project");
            if (this.project != null) {
                this.project.safeDispose();
            }
            progress.worked(10);
            TimedSessionCache.close();
            progress.subTask("Thread pools");
            ThreadUtils.shutdown();
            ExecutorWorker.shutdown();
            progress.worked(5);
            this.running = false;
            progress.subTask("Close Database Session");
            if (this.sessionContext != null) {
                Session s = this.sessionContext.peekSession();
                if (s != null) {
                    progress.subTask("Flushing Index Caches");
                    try {
                        Simantics.flushIndexCaches((IProgressMonitor)progress.newChild(20), s);
                    }
                    catch (Throwable t) {
                        LOGGER.error("Failed to flush index caches.", t);
                    }
                    if ("true".equals(System.getProperty("org.simantics.db.persistQueries"))) {
                        progress.subTask("Saving Queries");
                        Simantics.saveQueries(s);
                    }
                }
                progress.subTask("Close Database Session");
                this.sessionContext.safeDispose();
                this.sessionContext = null;
                Simantics.setSessionContext(null);
            }
            if (this.simanticsBindings != null) {
                Bindings.classBindingFactory.removeFactory((BindingProvider)this.simanticsBindings);
                this.simanticsBindings = null;
            }
            Simantics.setClipboard((SimanticsClipboard)new SimanticsClipboardImpl());
            progress.worked(50);
            this.session = null;
            this.projectResource = null;
            this.currentDatabaseDriver = null;
            DependenciesRelation.assertFinishedTracking();
        }
        catch (Exception e) {
            platformException = new PlatformException("Failed to shutdown Simantics Platform", e);
        }
        progress.worked(10);
        progress.subTask("Shutting down database");
        try {
            if (this.databasebManagement != null) {
                this.databasebManagement.shutdown();
            }
        }
        catch (Throwable t) {
            LOGGER.error("Database shutdown failed.", t);
        }
        progress.worked(10);
        progress.subTask("Clear index status");
        try {
            DatabaseIndexing.clearAllDirty();
        }
        catch (IOException e) {
            LOGGER.error("Problems encountered while refreshing database index states, see exception for details.", (Throwable)e);
        }
        progress.worked(5);
        if (clearTemporaryFiles) {
            progress.subTask("Clearing Workspace Temporary Directory");
            try {
                Simantics.clearTemporaryDirectory();
            }
            catch (Throwable t) {
                LOGGER.error("Failed to clear the temporary directory.", t);
            }
        }
        progress.worked(10);
        if (platformException != null) {
            throw platformException;
        }
        Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
    }

    public void stateChanged(LifecycleSupport.LifecycleState newState) {
        if (newState == LifecycleSupport.LifecycleState.CLOSED && this.running && Platform.isRunning()) {
            this.mainThread.interrupt();
        }
    }

    public boolean discardSessionUndoHistory() {
        UndoContext uc;
        UndoRedoSupport urs;
        Session s = this.session;
        if (s != null && (urs = (UndoRedoSupport)s.peekService(UndoRedoSupport.class)) != null && (uc = urs.getUndoContext(s)) != null) {
            uc.clear();
            return true;
        }
        return false;
    }

    public void reconnect(String databaseDriverId) throws Exception {
        if (this.currentDatabaseDriver != null) {
            databaseDriverId = this.currentDatabaseDriver;
        }
        INSTANCE.startUp(databaseDriverId, null, RecoveryPolicy.ThrowError, OntologyRecoveryPolicy.ThrowError, true, null);
    }

    private void dumpPlatformBundleState() {
        BundleDescription[] bs = Platform.getPlatformAdmin().getState().getBundles();
        System.out.println("Total bundles: " + bs.length);
        BundleDescription[] bundleDescriptionArray = bs;
        int n = bs.length;
        int n2 = 0;
        while (n2 < n) {
            BundleDescription b = bundleDescriptionArray[n2];
            System.out.format("%-80s @ %s\n", b.toString(), b.getLocation());
            ++n2;
        }
    }

    private Ini loadOrCreateDatabaseIni(Path path, String databaseDriverId) throws InvalidFileFormatException, IOException {
        String iniId;
        File f = path.toFile();
        Ini dbIni = Files.isRegularFile(path, new LinkOption[0]) ? new Ini(f) : new Ini();
        String string = iniId = dbIni != null ? dbIni.get((Object)"driver", (Object)"id") : null;
        if (iniId == null) {
            dbIni.put("driver", "id", (Object)databaseDriverId);
            dbIni.store(f);
        }
        return dbIni;
    }

    public static enum OntologyRecoveryPolicy {
        ThrowError,
        Merge,
        ReinstallDatabase,
        Bypass;

    }

    static class PlatformSessionModel
    implements SessionModel {
        private final Resource sessionModel;

        public PlatformSessionModel(Resource model) {
            this.sessionModel = model;
        }

        public Resource getResource() {
            return this.sessionModel;
        }
    }

    public static enum RecoveryPolicy {
        ThrowError,
        FixError;

    }
}

