/*
 * Decompiled with CFR 0.152.
 */
package org.simantics;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.Platform;
import org.simantics.PlatformException;
import org.simantics.utils.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseBaselines {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseBaselines.class);
    private static final boolean REQUIRE_INDEX_IN_BASELINE = false;
    private static final String DB_DIRECTORY = "db";
    private static final String INDEX_DIRECTORY = ".metadata/.plugins/org.simantics.db.indexing";
    private static final DateTimeFormatter TIMESTAMP_FORMAT = DateTimeFormatter.ofPattern("d. MMM yyyy HH:mm:ss");

    public static boolean handleBaselineDatabase(Path installLocation, boolean databaseExists) throws PlatformException {
        Path workspaceLocation = Platform.getLocation().toFile().toPath();
        Path baselineIndicatorFile = workspaceLocation.resolve(".baselined");
        if (Files.isRegularFile(baselineIndicatorFile, new LinkOption[0])) {
            return true;
        }
        Path baseline = DatabaseBaselines.resolveBaselineFile(installLocation);
        if (baseline == null) {
            baseline = DatabaseBaselines.getAutomaticBaselinePath();
            if (baseline == null) {
                return false;
            }
            if (databaseExists) {
                return false;
            }
            if (!DatabaseBaselines.existsAutomaticBaseline()) {
                return false;
            }
        }
        DatabaseBaselines.validateBaselineFile(baseline);
        DatabaseBaselines.validateWorkspaceForBaselineInitialization(workspaceLocation);
        DatabaseBaselines.initializeWorkspaceWithBaseline(baseline, workspaceLocation, baselineIndicatorFile);
        return true;
    }

    private static Path resolveBaselineFile(Path installLocation) throws PlatformException {
        Path installedBaseline;
        String dbBaselineArchive = System.getProperty("org.simantics.db.baseline", null);
        if (dbBaselineArchive == null) {
            return null;
        }
        Path baseline = Paths.get(dbBaselineArchive, new String[0]);
        if (baseline.isAbsolute()) {
            if (!Files.isRegularFile(baseline, new LinkOption[0])) {
                throw new PlatformException("Specified database baseline archive " + String.valueOf(baseline) + " does not exist. Cannot initialize workspace database from baseline.");
            }
            return baseline;
        }
        if (installLocation != null && Files.isRegularFile(installedBaseline = installLocation.resolve(dbBaselineArchive), new LinkOption[0])) {
            return installedBaseline;
        }
        if (!Files.isRegularFile(baseline, new LinkOption[0])) {
            throw new PlatformException("Specified database baseline archive " + String.valueOf(baseline) + " does not exist in either the install location (" + String.valueOf(installLocation) + ") or the working directory (" + String.valueOf(Paths.get(".", new String[0]).toAbsolutePath()) + "). Cannot initialize workspace database.");
        }
        return null;
    }

    private static boolean useAutomaticBaseline() {
        return DatabaseBaselines.getAutomaticBaselinePath() != null;
    }

    private static Path getAutomaticBaselinePath() {
        if ("true".equals(System.getProperty("org.simantics.db.baseline.automatic"))) {
            return Paths.get("automatic_baseline", "baseline.zip");
        }
        return null;
    }

    private static boolean existsAutomaticBaseline() {
        Path baselineFile = DatabaseBaselines.getAutomaticBaselinePath();
        if (baselineFile == null) {
            return false;
        }
        return Files.exists(baselineFile, new LinkOption[0]);
    }

    public static boolean shouldCreateAutomaticBaseline(boolean existsDatabase) throws PlatformException {
        if (!DatabaseBaselines.useAutomaticBaseline()) {
            return false;
        }
        if (existsDatabase) {
            return false;
        }
        return !DatabaseBaselines.existsAutomaticBaseline();
    }

    public static void createAutomaticBaseline(Path dbLocation) throws PlatformException {
        if (DatabaseBaselines.existsAutomaticBaseline()) {
            return;
        }
        try {
            DatabaseBaselines.packageBaseline(dbLocation.getParent(), DatabaseBaselines.getAutomaticBaselinePath());
        }
        catch (IOException e) {
            LOGGER.error("Error while creating automatic baseline", (Throwable)e);
        }
    }

    public static Path packageBaseline(Path fromWorkspace, Path packageFilePath) throws IOException {
        Files.createDirectories(packageFilePath.getParent(), new FileAttribute[0]);
        return DatabaseBaselines.compressZip(fromWorkspace, DatabaseBaselines.collectBaselinePaths(fromWorkspace), packageFilePath);
    }

    private static List<Path> collectBaselinePaths(Path workspace) throws IOException {
        Path dbPath = workspace.resolve(DB_DIRECTORY);
        Path indexPath = workspace.resolve(INDEX_DIRECTORY);
        if (!Files.isDirectory(dbPath, new LinkOption[0])) {
            throw new IllegalArgumentException("workspace database directory " + String.valueOf(dbPath) + " does not exist");
        }
        List<Path> paths = Files.walk(dbPath, new FileVisitOption[0]).collect(Collectors.toList());
        if (Files.isDirectory(indexPath, new LinkOption[0])) {
            List indexPaths = Files.walk(indexPath, new FileVisitOption[0]).collect(Collectors.toList());
            paths.addAll(indexPaths);
        }
        return paths;
    }

    private static Path compressZip(Path relativeRoot, List<Path> paths, Path zipFile) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Compressing " + paths.size() + " path entries into ZIP file " + String.valueOf(zipFile));
        }
        try {
            Path path;
            block15: {
                Throwable throwable = null;
                Object var4_5 = null;
                ZipOutputStream zout = new ZipOutputStream(Files.newOutputStream(zipFile, new OpenOption[0]));
                try {
                    DatabaseBaselines.compressZip(relativeRoot, zout, paths);
                    path = zipFile;
                    if (zout == null) break block15;
                }
                catch (Throwable throwable2) {
                    try {
                        if (zout != null) {
                            zout.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                zout.close();
            }
            return path;
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Compressed " + paths.size() + " entries into " + String.valueOf(zipFile));
            }
        }
    }

    private static void compressZip(Path relativeRoot, ZipOutputStream zout, List<Path> paths) throws IOException {
        for (Path p : paths) {
            Path rp = relativeRoot.relativize(p);
            Object name = rp.toString();
            if (Files.isDirectory(p, new LinkOption[0])) {
                name = ((String)name).endsWith("/") ? name : (String)name + "/";
                zout.putNextEntry(new ZipEntry((String)name));
                continue;
            }
            zout.putNextEntry(new ZipEntry((String)name));
            FileUtils.copy((File)p.toFile(), (OutputStream)zout);
            zout.closeEntry();
        }
    }

    public static byte[] baselineIndicatorContents(Path path) throws IOException {
        return String.format("%s%n%s%n", path.toString(), Instant.now().atZone(ZoneId.systemDefault()).format(TIMESTAMP_FORMAT)).getBytes("UTF-8");
    }

    public static void validateWorkspaceForBaselineInitialization(Path workspaceLocation) throws PlatformException {
        try {
            Path db = workspaceLocation.resolve(DB_DIRECTORY);
            if (Files.exists(db, new LinkOption[0])) {
                throw new PlatformException("Database location " + String.valueOf(db) + " already exists. Cannot re-initialize workspace from baseline.");
            }
        }
        catch (IOException e) {
            throw new PlatformException("Failed to validate workspace for baseline initialization", e);
        }
    }

    private static boolean isEmptyDirectory(Path dir) throws IOException {
        return Files.walk(dir, new FileVisitOption[0]).count() == 1L;
    }

    public static void validateBaselineFile(Path baseline) throws PlatformException {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (ZipFile zip = new ZipFile(baseline.toFile());){
                ZipEntry db = zip.getEntry(DB_DIRECTORY);
                if (db == null) {
                    throw new PlatformException("Baseline archive does not contain database directory 'db'");
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new PlatformException("Failed to validate baseline archive " + String.valueOf(baseline), e);
        }
    }

    public static void initializeWorkspaceWithBaseline(Path baseline, Path workspaceLocation, Path indicatorPath) throws PlatformException {
        try {
            Files.createDirectories(workspaceLocation, new FileAttribute[0]);
            FileUtils.extractZip((File)baseline.toFile(), (File)workspaceLocation.toFile());
            if (indicatorPath != null) {
                Files.write(indicatorPath, DatabaseBaselines.baselineIndicatorContents(indicatorPath), new OpenOption[0]);
            }
        }
        catch (IOException e) {
            throw new PlatformException(e);
        }
    }

    public static void main(String[] args) throws IOException {
        DatabaseBaselines.packageBaseline(Paths.get("D:/temp/desktop/workspace", new String[0]), Paths.get("d:/temp/desktop/workspace/baseline.zip", new String[0]));
    }
}

