/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.workbench.internal.contributions;

import java.util.Map;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.simantics.workbench.internal.Activator;

public class DumpStackTracesButtonTrim
extends Composite {
    LocalResourceManager resourceManager;
    private final Button b;
    private final Clipboard clipboard;

    public DumpStackTracesButtonTrim(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.b = new Button((Composite)this, 8);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.b);
        this.clipboard = new Clipboard(parent.getDisplay());
        this.b.setToolTipText("Dump thread stack traces to clipboard");
        this.b.setImage(this.resourceManager.createImage(Activator.getImageDescriptor("img/page_white_paste_table.png")));
        this.b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DumpStackTracesButtonTrim.this.dumpStackTraces();
            }
        });
        this.b.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                DumpStackTracesButtonTrim.this.clipboard.dispose();
            }
        });
    }

    protected void dumpStackTraces() {
        StringBuilder text = new StringBuilder();
        Map<Thread, StackTraceElement[]> traces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> entry : traces.entrySet()) {
            Thread thread = entry.getKey();
            StackTraceElement[] trace = entry.getValue();
            text.append(thread.toString());
            text.append('\n');
            StackTraceElement[] stackTraceElementArray = trace;
            int n = trace.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement element = stackTraceElementArray[n2];
                text.append('\t');
                text.append(element.toString());
                text.append('\n');
                ++n2;
            }
            text.append('\n');
        }
        this.clipboard.setContents(new Object[]{text.toString()}, new Transfer[]{TextTransfer.getInstance()});
    }
}

