/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.workbench.internal.contributions;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.simantics.Simantics;
import org.simantics.db.Session;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.management.ISessionContextChangedListener;
import org.simantics.db.management.ISessionContextProvider;
import org.simantics.db.management.SessionContextChangedEvent;
import org.simantics.ui.jobs.SessionGarbageCollectorJob;
import org.simantics.workbench.internal.Activator;

/**
 * @author Tuukka Lehtonen
 */
public class FlushRequestsButtonTrim extends Composite {

    LocalResourceManager resourceManager;

    class SessionContextListener implements ISessionContextChangedListener {
        @Override
        public void sessionContextChanged(final SessionContextChangedEvent event) {
            if (isDisposed())
                return;
            getDisplay().asyncExec(new Runnable() {
                @Override
                public void run() {
                    if (isDisposed())
                        return;
                    sessionChanged(event.getNewValue());
                }
            });
        }
    }

    SessionContextListener listener = new SessionContextListener();
    private Button b;

    public FlushRequestsButtonTrim(Composite parent) {
        super(parent, SWT.NONE);

        setLayout(new FillLayout());

        b = new Button(this, SWT.PUSH);
        this.resourceManager = new LocalResourceManager(JFaceResources.getResources(), b);

        final ISessionContextProvider provider = Simantics.getSessionContextProvider();
        if (provider != null) {
            provider.addContextChangedListener(listener);
        }

        b.setToolTipText("Flush database caches");
        b.setImage(resourceManager.createImage(Activator.getImageDescriptor("img/paintcan.png")));
        b.addSelectionListener(new SelectionAdapter() {
            @Override
            public void widgetSelected(SelectionEvent e) {
                Session session = Simantics.peekSession();
                if (session != null)
                    SessionGarbageCollectorJob.getInstance().rescheduleNow();
            }
        });
        b.addDisposeListener(new DisposeListener() {
            @Override
            public void widgetDisposed(DisposeEvent e) {
                provider.removeContextChangedListener(listener);
            }
        });

        sessionChanged(Simantics.getSessionContext());
    }

    private void sessionChanged(ISessionContext sessionContext) {
        b.setEnabled(sessionContext != null);
    }

}