/*******************************************************************************
 * Copyright (c) 2014 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.workbench.search.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.DisposableListener;

/**
 * @author Tuukka Lehtonen
 */
class ActiveModelsListener extends DisposableListener<Collection<Resource>> {

    private Runnable callback;
    private Set<Resource> previouslyActive;

    public ActiveModelsListener(Runnable callback) {
        if (callback == null)
            throw new NullPointerException("null callback");
        this.callback = callback;
    }

    @Override
    public void execute(Collection<Resource> models) {
        Set<Resource> set = new HashSet<Resource>(models);
        Set<Resource> previous = previouslyActive;
        if (previous != null && !previous.equals(set))
            callback.run();
        previouslyActive = set;
    }

    @Override
    public void exception(Throwable t) {
        Activator.getDefault().getLog().log(new Status(IStatus.ERROR, Activator.PLUGIN_ID, t.getLocalizedMessage(), t));
    }

    @Override
    public void dispose() {
        super.dispose();
        previouslyActive = null;
    }

}