package org.simantics.workbench.ontology;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class WorkbenchResource {
    
    public final Resource DependenciesSearchContribution;
    public final Resource DependenciesSearchFunction;
    public final Resource HasWorkbenchSearchFunction;
    public final Resource SearchContribution;
    public final Resource SearchContribution_isEnabledByDefault;
    public final Resource SearchContribution_isEnabledByDefault_Inverse;
    public final Resource SearchFunction;
    public final Resource SearchParameter;
    public final Resource hasSearchFunction;
    public final Resource hasSearchParameter;
        
    public static class URIs {
        public static final String DependenciesSearchContribution = "http://www.simantics.org/Workbench-1.2/DependenciesSearchContribution";
        public static final String DependenciesSearchFunction = "http://www.simantics.org/Workbench-1.2/DependenciesSearchFunction";
        public static final String HasWorkbenchSearchFunction = "http://www.simantics.org/Workbench-1.2/HasWorkbenchSearchFunction";
        public static final String SearchContribution = "http://www.simantics.org/Workbench-1.2/SearchContribution";
        public static final String SearchContribution_isEnabledByDefault = "http://www.simantics.org/Workbench-1.2/SearchContribution/isEnabledByDefault";
        public static final String SearchContribution_isEnabledByDefault_Inverse = "http://www.simantics.org/Workbench-1.2/SearchContribution/isEnabledByDefault/Inverse";
        public static final String SearchFunction = "http://www.simantics.org/Workbench-1.2/SearchFunction";
        public static final String SearchParameter = "http://www.simantics.org/Workbench-1.2/SearchParameter";
        public static final String hasSearchFunction = "http://www.simantics.org/Workbench-1.2/hasSearchFunction";
        public static final String hasSearchParameter = "http://www.simantics.org/Workbench-1.2/hasSearchParameter";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public WorkbenchResource(ReadGraph graph) {
        DependenciesSearchContribution = getResourceOrNull(graph, URIs.DependenciesSearchContribution);
        DependenciesSearchFunction = getResourceOrNull(graph, URIs.DependenciesSearchFunction);
        HasWorkbenchSearchFunction = getResourceOrNull(graph, URIs.HasWorkbenchSearchFunction);
        SearchContribution = getResourceOrNull(graph, URIs.SearchContribution);
        SearchContribution_isEnabledByDefault = getResourceOrNull(graph, URIs.SearchContribution_isEnabledByDefault);
        SearchContribution_isEnabledByDefault_Inverse = getResourceOrNull(graph, URIs.SearchContribution_isEnabledByDefault_Inverse);
        SearchFunction = getResourceOrNull(graph, URIs.SearchFunction);
        SearchParameter = getResourceOrNull(graph, URIs.SearchParameter);
        hasSearchFunction = getResourceOrNull(graph, URIs.hasSearchFunction);
        hasSearchParameter = getResourceOrNull(graph, URIs.hasSearchParameter);
    }
    
    public static WorkbenchResource getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        WorkbenchResource ret = session.peekService(WorkbenchResource.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new WorkbenchResource(qc.getIndependentGraph(graph));
            session.registerService(WorkbenchResource.class, ret);
        }
        return ret;
    }
    
    public static WorkbenchResource getInstance(RequestProcessor session) throws DatabaseException {
        WorkbenchResource ret = session.peekService(WorkbenchResource.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<WorkbenchResource>() {
                public WorkbenchResource perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new WorkbenchResource(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(WorkbenchResource.class, ret);
        }
        return ret;
    }
    
}

