/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling;

import java.util.Collection;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;

public class AssignSymbolGroupRequest
extends WriteRequest {
    Collection<Resource> addedSymbolGroup;
    Collection<Resource> removedSymbolGroup;
    Collection<Resource> symbols;

    public AssignSymbolGroupRequest(Collection<Resource> addedSymbolGroups, Collection<Resource> removedSymbolGroups, Collection<Resource> symbols) {
        this.addedSymbolGroup = addedSymbolGroups;
        this.removedSymbolGroup = removedSymbolGroups;
        this.symbols = symbols;
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        AssignSymbolGroupRequest.assignSymbolGroup(graph, this.addedSymbolGroup, this.removedSymbolGroup, this.symbols);
    }

    public static void assignSymbolGroup(WriteGraph graph, Collection<Resource> addedSymbolGroups, Collection<Resource> removedSymbolGroups, Collection<Resource> symbols) throws DatabaseException {
        graph.markUndoPoint();
        DiagramResource DIA = DiagramResource.getInstance((ReadGraph)graph);
        for (Resource symbol : symbols) {
            for (Resource group : addedSymbolGroups) {
                graph.claim(group, DIA.HasSymbol, symbol);
            }
            for (Resource group : removedSymbolGroups) {
                graph.deny(group, DIA.HasSymbol, symbol);
            }
        }
    }
}

