package org.simantics.modeling.adapters;

import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.swt.graphics.RGB;
import org.simantics.Simantics;
import org.simantics.browsing.ui.model.labeldecorators.LabelDecorationRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.modeling.ColorDescriptorUtil;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.tuple.Tuple3;

public abstract class SCLLabelColorRule implements LabelDecorationRule {

    private Resource rule;
    private Resource predicate;
    
    public SCLLabelColorRule(ReadGraph graph, Resource rule, Resource predicate) {
        this.rule = rule;
        this.predicate = predicate;
    }
    
    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class);
    }

    @SuppressWarnings("unchecked")
    protected <Color> Color decorateColor(ReadGraph graph, Object content, Color color, String column, int itemIndex) {
        try {
            Variable ruleVariable = Variables.getVariable(graph, rule);
            Function fn = ruleVariable.getPossiblePropertyValue(graph, predicate);
            if (fn != null) {
                Tuple3 prevColor = color != null ? ColorDescriptorUtil.colorDescriptorAsTuple3((ColorDescriptor)color) : null;
                Tuple3 result = Simantics.applySCLRead(graph, fn, content, prevColor, column, itemIndex);
                int r = (int)(((double)result.c0) * 255);
                int g = (int)(((double)result.c1) * 255);
                int b = (int)(((double)result.c2) * 255);
                return (Color)ColorDescriptor.createFrom(new RGB(r, g, b));
            } else {
                return color;
            }
        } catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }
}