package org.simantics.modeling;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.QueryIndexUtils;
import org.simantics.diagram.stubs.DiagramResource;

public class GetSymbolGroups {

    public static Collection<Resource> getSymbolGroups(ReadGraph graph, Resource indexRoot) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance(graph);
        Collection<Resource> results = QueryIndexUtils.searchByTypeShallow(graph, indexRoot, DIA.SymbolReferenceLibrary);
        return results;
    }
}
