/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.document.ui;

import java.util.function.Supplier;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.StatusLineContributionItem;
import org.simantics.Simantics;
import org.simantics.db.Session;
import org.simantics.db.common.request.ParametrizedRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.combinations.Combinators;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.document.ui.CSSModuleEditorDocumentProvider;
import org.simantics.document.ui.CSSSourceViewerConfiguration;
import org.simantics.document.ui.SharedTextColors;
import org.simantics.ui.workbench.IResourceEditorInput;
import org.simantics.ui.workbench.ResourceEditorSupport;
import org.simantics.ui.workbench.TitleUpdater;
import org.simantics.ui.workbench.TitleWithParentNameRequest;
import org.simantics.ui.workbench.ToolTipRequest;
import org.simantics.ui.workbench.editor.input.InputValidationCombinators;

public class CSSEditor
extends TextEditor {
    public static final String EDITOR_ID = "org.simantics.document.ui.csseditor";
    private boolean disposed = false;
    private ParametrizedRead<IResourceEditorInput, Boolean> INPUT_VALIDATOR = Combinators.compose((ParametrizedRead)InputValidationCombinators.hasURI(), (ParametrizedRead)InputValidationCombinators.extractInputResource());
    private ResourceEditorSupport support;
    private ISharedTextColors sharedColors;

    public CSSEditor() {
        this.preInitialize();
    }

    public boolean isTabsToSpacesConversionEnabled() {
        return true;
    }

    protected void preInitialize() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        this.sharedColors = new SharedTextColors(display);
        CSSSourceViewerConfiguration sourceViewer = new CSSSourceViewerConfiguration((Device)display, this.sharedColors);
        this.setDocumentProvider((IDocumentProvider)new CSSModuleEditorDocumentProvider(sourceViewer));
        this.setSourceViewerConfiguration(sourceViewer);
    }

    protected ParametrizedRead<IResourceEditorInput, Boolean> getInputValidator() {
        return this.INPUT_VALIDATOR;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.support = new ResourceEditorSupport((IEditorPart)this, this.getInputValidator());
        this.support.activateValidation();
        try {
            this.getResourceInput().init(null);
        }
        catch (DatabaseException e) {
            throw new PartInitException("Failed to initialize " + String.valueOf(input), (Throwable)e);
        }
    }

    protected IResourceEditorInput getResourceInput() {
        return (IResourceEditorInput)this.getEditorInput();
    }

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        StatusLineContributionItem statusLineContribution = new StatusLineContributionItem("InputPosition", true, 14);
        this.setStatusField((IStatusField)statusLineContribution, "InputPosition");
        this.getEditorSite().getActionBars().getStatusLineManager().add((IContributionItem)statusLineContribution);
        this.getEditorSite().getActionBars().updateActionBars();
        this.updatePartName();
    }

    protected void updatePartName() {
        this.setPartName(this.getEditorInput().getName());
        Session session = Simantics.peekSession();
        if (session != null) {
            Supplier<Boolean> disposedCallback = this::isDisposed;
            session.asyncRequest((Read)new TitleWithParentNameRequest(this.getResourceInput()), (Listener)new TitleUpdater(this.getSite().getShell().getDisplay(), arg_0 -> ((CSSEditor)this).setPartName(arg_0), disposedCallback));
            session.asyncRequest((Read)new ToolTipRequest(this.getSite().getId(), this.getResourceInput()), (Listener)new TitleUpdater(this.getSite().getShell().getDisplay(), arg_0 -> ((CSSEditor)this).setTitleToolTip(arg_0), disposedCallback));
        }
    }

    public void dispose() {
        this.disposed = true;
        if (this.support != null) {
            this.support.dispose();
            this.support = null;
        }
        this.sharedColors.dispose();
        super.dispose();
    }

    public boolean isDisposed() {
        return this.disposed;
    }
}

