package org.simantics.document.ui.actions;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.layer0.Layer0;

public class NewDocumentFolder implements ActionFactory {
	Resource folderType;
	Resource relation;
	
	public NewDocumentFolder(ReadGraph graph, String folderTypeUri, String relationUri) throws DatabaseException {
		folderType = graph.getResource(folderTypeUri);
		relation = graph.getResource(relationUri);
	}
	
	@Override
	public Runnable create(Object target) {

		if(!(target instanceof Resource))
			return null;

		final Resource resource = (Resource)target;

		return new Runnable() {
			@Override
			public void run() {
				Simantics.getSession().asyncRequest(new WriteRequest() {
					
					@Override
					public void perform(WriteGraph graph) throws DatabaseException {
					    graph.markUndoPoint();
					    
						Layer0 l0 = Layer0.getInstance(graph);

	                    String name = NameUtils.findFreshName(graph, Messages.NewDocumentFolder_Folder, resource, relation);
	                    Resource folder = graph.newResource();
	                    graph.claim(folder, l0.InstanceOf, folderType);
	                    graph.claimLiteral(folder, l0.HasName, name);
	                    graph.claim(resource, relation, folder);
					}
					
				});
			}
		};
	}
}
