package org.simantics.scl.compiler.internal.parsing.types;

import org.simantics.scl.compiler.elaboration.contexts.TypeTranslationContext;
import org.simantics.scl.compiler.internal.types.TypeElaborationContext;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kind;
import org.simantics.scl.compiler.types.kinds.Kinds;

import gnu.trove.map.hash.TObjectIntHashMap;
import gnu.trove.set.hash.TIntHashSet;



public class TListAst extends TypeAst {
    public final TypeAst component;
    
    public TListAst(TypeAst component) {
        this.component = component;
    }

    @Override
    public void toString(StringBuilder b) {
        b.append('[');
        component.toString(b);
        b.append(']');
    }

    @Override
    public Type toType(TypeTranslationContext context, Kind expectedKind) {
        context.unify(location, Kinds.STAR, expectedKind);
        return Types.list(component.toType(context, Kinds.STAR));
    }

    @Override
    public Type toType(TypeElaborationContext context) {
        return Types.list(component.toType(context));
    }
    
    @Override
    public int getPrecedence() {
        return 0;
    }

    @Override
    public void collectReferences(TObjectIntHashMap<String> typeNameMap,
            TIntHashSet set) {
        component.collectReferences(typeNameMap, set);
    }
}
