package org.simantics.scl.compiler.internal.codegen.ssa.statements;

import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAStatement;
import org.simantics.scl.compiler.internal.codegen.ssa.binders.BoundVarBinder;
import org.simantics.scl.compiler.internal.codegen.utils.SSASimplificationContext;
import org.simantics.scl.compiler.internal.codegen.utils.SSAValidationContext;

public abstract class LetStatement extends SSAStatement implements BoundVarBinder {
    BoundVar target;

    public LetStatement(BoundVar target) {
        setTarget(target);
    }
    
    @Override
    public void simplify(SSASimplificationContext context) {
        if(target.hasNoOccurences()) {
            remove();
            context.markModified("dead-let-statement");
        }                   
    }
    
    public BoundVar getTarget() {
        return target;
    }
    
    public void setTarget(BoundVar target) {
        this.target = target;
        target.parent = this;
    }
    
    @Override
    public void addBoundVariablesTo(SSAValidationContext context) {
        context.validBoundVariables.add(target);
    }

}
