package org.simantics.scl.compiler.elaboration.chr;

import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

import gnu.trove.set.hash.THashSet;

public interface CHRRelation {
    public static final TVar A = Types.var(Kinds.STAR);
    
    TVar[] getTypeVariables();
    Type[] getParameterTypes();
    TPred[] getTypeConstraints();
    default String[] getFieldNames() {
        return null;
    }
    void collectEnforceEffects(THashSet<Type> effects);
    void collectQueryEffects(THashSet<Type> effects);
}
