package org.simantics.scl.compiler.constants;


import org.objectweb.asm.Label;
import org.simantics.scl.compiler.internal.codegen.continuations.Cont;
import org.simantics.scl.compiler.internal.codegen.references.IVal;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.internal.codegen.utils.TransientClassBuilder;
import org.simantics.scl.compiler.types.Types;

public class BooleanConstant extends Constant {
    public static final BooleanConstant TRUE = new BooleanConstant(true);
    public static final BooleanConstant FALSE = new BooleanConstant(false);
    
    boolean value;

    public BooleanConstant(boolean value) {
        super(Types.BOOLEAN);
        this.value = value;
    }
    
    public boolean getValue() {
        return value;
    }
    
    @Override
    public void push(MethodBuilder mb) {
        mb.loadConstant(value);
    }
    
    @Override
    public String toString() {
        return String.valueOf(value);
    }
    
    @Override
    public void deconstruct(MethodBuilder mb, IVal parameter, Cont success,
            Label failure) {
        mb.push(parameter, Types.BOOLEAN);
        mb.ifZeroComparisonBranch(failure, value ? "==" : "!=");
        mb.jump(success);
    }
    
    @Override
    public int constructorTag() {
        return 0;
    }

    @Override
    public Object realizeValue(TransientClassBuilder classBuilder) {
        return value;
    }
}
