package org.simantics.scl.compiler.completions;

public class PrefixUtil {
    public static String findPrefix(String sourceText, int end) {
        int position;
        for(position=end-1;position >= 0 && isPrefixChar(sourceText.charAt(position));--position);
        ++position;
        while(position < end && !isPrefixStart(sourceText.charAt(position)))
            ++position;
        return sourceText.substring(position, end);
    }

    private static boolean isPrefixStart(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    private static boolean isPrefixChar(char c) {
        return Character.isJavaIdentifierPart(c) || c=='.';
    }
    
    public static String[] splitPrefix(String prefix) {
        int partCount = 1;
        for(int i=0;i<prefix.length();++i)
            if(prefix.charAt(i) == '.')
                ++partCount;
        String[] result = new String[partCount];
        int partId = 0;
        int begin = 0;
        for(int i=0;i<prefix.length();++i)
            if(prefix.charAt(i) == '.') {
                result[partId++] = prefix.substring(begin, i);
                begin = i+1;
            }
        result[partId] = prefix.substring(begin);
        return result;
    }
}
