package org.simantics.modeling.tests.commands;

import org.simantics.Simantics;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.testing.base.CommandSequenceTest;
import org.simantics.db.testing.common.WriteCommand;
import org.simantics.project.IProject;
import org.simantics.simulation.experiment.IExperiment;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.simulation.project.IExperimentManagerListener;

public class WaitActiveExperiment extends WriteCommand<CommandSequenceTest> implements IExperimentManagerListener {

	boolean done = false;
	
	@Override
	public void run(CommandSequenceTest environment) throws DatabaseException {
		try {
			IProject project = Simantics.getProject(); 
            final IExperimentManager experimentManager = project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
            if (experimentManager != null) {
            	IExperiment experiment = experimentManager.getActiveExperiment();
            	if(experiment == null) {
                	experimentManager.addListener(this);
                	while(!done) {
                		Thread.sleep(50);
                	}
                	// Cannot because of bean comparison
                	//experimentManager.removeListener(this);
            	}
            }
		} catch (Exception e) {
			throw new DatabaseException(e);
		}
	}

	@Override
	public void activeExperimentLoaded(IExperiment experiment) {
		done = true;
	}

	@Override
	public void activeExperimentUnloaded() {
	}

	@Override
	public void managerDisposed() {
	}

}