package org.simantics.modeling.tests.commands;

import junit.framework.Assert;
import junit.framework.AssertionFailedError;

import org.simantics.db.layer0.util.EvaluatingListener;
import org.simantics.db.layer0.util.EvaluatingListener.Criterion;
import org.simantics.db.layer0.util.EvaluatingListener.Evaluation;
import org.simantics.db.testing.common.Command;
import org.simantics.modeling.tests.cases.ModelingCommandSequenceTest;
import org.simantics.modeling.tests.traits.SingleResourceTrait;

public class AssertStateValue extends Command<ModelingCommandSequenceTest> {

	
	private transient final SingleResourceTrait run;
	private transient final String rvi;
	private transient final Number expectedValue;
	private transient final double tolerance;
	
	public AssertStateValue(SingleResourceTrait run, String rvi, Number expectedValue, double tolerance) {
		this.run = run;
		this.rvi = rvi;
		this.expectedValue = expectedValue;
		this.tolerance = tolerance;
	}
	
	public void run(ModelingCommandSequenceTest environment) throws Exception {
		
		//final double tolerance = 0.0001;
		
		Criterion<Number> criterion = new EvaluatingListener.Criterion<Number>() {
			@Override
			public Evaluation evaluate(Number result) {
				if (result == null){
					return Evaluation.IGNORE;
				}
				else{
					double resultDouble = result.doubleValue();
					double expectedDouble = expectedValue.doubleValue();
					if (Math.abs(expectedDouble - resultDouble) <= tolerance){
					return Evaluation.ACCEPT;
					}
				}
				return Evaluation.IGNORE;
			}

		};
		
		Number result = Utils.readValue(run, rvi, criterion);
		if (result != null){
			double resultDouble = result.doubleValue();
			double expectedDouble = expectedValue.doubleValue();
			
			Assert.assertEquals(expectedDouble, resultDouble, tolerance);
		}
		else
			throw new AssertionFailedError();


	}

}