/*******************************************************************************
 * Copyright (c) 2023 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.document.ui.prefs;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.simantics.document.ui.Activator;

/**
 * @author Tuukka Lehtonen
 */
public final class DocumentsPreferences {

	/**
	 * Boolean preference, default value
	 * {@value #DEFAULT_PREFER_EXTERNAL_EDITOR_FOR_DOCUMENTS}.
	 */
	public static final String P_PREFER_EXTERNAL_EDITOR_FOR_DOCUMENTS = "preferExternalEditorForEmbeddedDocuments"; //$NON-NLS-1$

	/**
	 * This corresponds to how ExternalEditorAdapter has always worked in the past.
	 */
	public static final boolean DEFAULT_PREFER_EXTERNAL_EDITOR_FOR_DOCUMENTS = false;

	public boolean preferExternalEditorForDocuments;

	public DocumentsPreferences(boolean preventSimulationWithErrors) {
		this.preferExternalEditorForDocuments = preventSimulationWithErrors;
	}

	public static DocumentsPreferences getPreferences() {
		ScopedPreferenceStore store = new ScopedPreferenceStore(InstanceScope.INSTANCE, Activator.PLUGIN_ID);
		boolean peefd = store.getBoolean(P_PREFER_EXTERNAL_EDITOR_FOR_DOCUMENTS);
		return new DocumentsPreferences(peefd);
	}

}
