/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.document.ui;

import java.nio.file.Path;
import java.nio.file.Paths;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.simantics.document.ui.graphfile.ExternalEditorAdapter;

/**
 * The activator class controls the plug-in life cycle
 */
public class Activator extends AbstractUIPlugin {

	// The plug-in ID
	public static final String PLUGIN_ID = "org.simantics.document.ui"; //$NON-NLS-1$

	// The shared instance
	private static Activator plugin;
	
    public ImageDescriptor DOCUMENT_DECORATION_ICON;
    
	public ImageDescriptor cross;
	public ImageDescriptor clock_red;

    private static Path location;
	
	/**
	 * The constructor
	 */
	public Activator() {
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#start(org.osgi.framework.BundleContext)
	 */
	public void start(BundleContext context) throws Exception {
		
		super.start(context);
		
		plugin = this;

		Bundle bundle = context.getBundle();
		
		DOCUMENT_DECORATION_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/document_decoration.png")); //$NON-NLS-1$
		cross = ImageDescriptor.createFromURL(bundle.getResource("icons/silk_small/cross.png")); //$NON-NLS-1$
		clock_red = ImageDescriptor.createFromURL(bundle.getResource("icons/silk_small/clock_red.png")); //$NON-NLS-1$
		
		IPath ipath = Platform.getStateLocation(bundle);
		location = Paths.get(ipath.toOSString());
	}

	/*
	 * (non-Javadoc)
	 * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
	 */
	public void stop(BundleContext context) throws Exception {
	    ExternalEditorAdapter.stopFileWatcher();
		plugin = null;
		super.stop(context);
	}

	/**
	 * Returns the shared instance
	 *
	 * @return the shared instance
	 */
	public static Activator getDefault() {
		return plugin;
	}

	public static Path getInstanceLocation() {
	    return location;
	}
}
