/*******************************************************************************
 * Copyright (c) 2016 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     THTH ry - initial API and implementation
 *******************************************************************************/
package org.simantics.debug.browser.sections;

import java.io.PrintWriter;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.debug.browser.utils.Escapes;
import org.simantics.debug.browser.utils.ValueInfo;

public class ResourceInfoSection implements ResourceBrowserSection {

    ValueInfo valueInfo;
    boolean immutable;

    public ResourceInfoSection(ValueInfo valueInfo, boolean immutable) {
        this.valueInfo = valueInfo;
        this.immutable = immutable;
    }

    @Override
    public double getPriority() {
        return 2;
    }

    @Override
    public void toHtml(ReadGraph graph, PrintWriter out) throws DatabaseException {
        out.println("<div id=\"resourceInfoContent\">");
        out.println("<table>");
        if (immutable) {
            out.println("<tr><td colspan=\"2\" id=\"immutable\">IMMUTABLE</td></tr>");
        }
        if (valueInfo != null) {
            if (valueInfo.datatype != null) {
                out.print("<tr>");
                out.print("<td class=\"top_key\">Attached value data type</td>");
                out.print("<td class=\"resourceType\">");
                out.print(Escapes.html(valueInfo.datatype));
                out.println("</td></tr>");
            }
            out.print("<tr><td class=\"top_key\">Attached value</td>");
            out.print("<td id=\"attachedValue\">");
            out.print(Escapes.html(valueInfo.value));
            out.println("</td></tr>");
        }
        out.println("</table>");
        out.println("</div>");
    }

}
