/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.processors;

import java.util.Collection;
import java.util.HashMap;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.PrimitiveQueryUpdater;
import org.simantics.browsing.ui.BuiltinKeys.SelectedComparableFactoryKey;
import org.simantics.browsing.ui.NodeContext.PrimitiveQueryKey;
import org.simantics.browsing.ui.content.ComparableContextFactory;
import org.simantics.utils.datastructures.Pair;

public class UserSelectedComparableFactoryQueryProcessor extends AbstractPrimitiveQueryProcessor<ComparableContextFactory> {

    HashMap<NodeContext, ComparableContextFactory> factories = new HashMap<NodeContext, ComparableContextFactory>();
    HashMap<NodeContext, Pair<PrimitiveQueryKey<?>, PrimitiveQueryUpdater>> updaters = new HashMap<NodeContext, Pair<PrimitiveQueryKey<?>, PrimitiveQueryUpdater>>();

    @Override
    public String toString() {
        return "UserSelectedComparableFactoryProcessor";
    }

    @Override
    public Object getIdentifier() {
        return BuiltinKeys.SelectedComparableFactoryKey.class;
    }

    @Override
    public ComparableContextFactory query(PrimitiveQueryUpdater updater, NodeContext context,
            PrimitiveQueryKey<ComparableContextFactory> key) {
        updaters.put(context, new Pair<PrimitiveQueryKey<?>, PrimitiveQueryUpdater>(key, updater));
        ComparableContextFactory result = factories.get(context);
        if (result != null)
            return result;

        SelectedComparableFactoryKey k = (SelectedComparableFactoryKey) key;
        Collection<ComparableContextFactory> factories = k.getParameter(0);
        if (factories.isEmpty())
            return null;

        return factories.iterator().next();
    }

    public ComparableContextFactory getComparator(NodeContext context) {
        return factories.get(context);
    }

    /**
     * Invoked by the user interfaces for selecting comparators.
     * 
     * @param context
     * @param factory
     */
    @SuppressWarnings("unchecked")
    public void select(NodeContext context, ComparableContextFactory factory) {
        factories.put(context, factory);
        Pair<PrimitiveQueryKey<?>, PrimitiveQueryUpdater> p = updaters.get(context);
        if (p.second == null)
            throw new IllegalArgumentException("context not found in cache");
        p.second.scheduleReplace(context, (PrimitiveQueryKey<ComparableContextFactory>) p.first, factory);
    }

}
