/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.processors;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.common.EvaluatorData;
import org.simantics.browsing.ui.common.EvaluatorData.Evaluator;
import org.simantics.browsing.ui.common.EvaluatorData.EvaluatorTree;
import org.simantics.browsing.ui.content.LabelerFactory;

/**
 * A query processor for resolving available {@link LabelerFactory} instances
 * for a {@link NodeContext}.
 * 
 * <p>
 * This implementation works completely based on the generic
 * {@link AbstractFactoryResolverQueryProcessor} and an {@link EvaluatorData}
 * which is used to guide the resolution. See
 * {@link AbstractFactoryResolverQueryProcessor} for an explanation of the
 * generic logic.
 * </p>
 * 
 * @author Tuukka Lehtonen
 */
public class LabelerFactoryResolver extends AbstractFactoryResolverQueryProcessor<LabelerFactory> {

    public LabelerFactoryResolver(EvaluatorData data) {
        super(data, BuiltinKeys.LABELER_FACTORIES);
    }

    @Override
    protected EvaluatorTree<LabelerFactory> getEvaluatorTree(Evaluator evaluator) {
        return evaluator.getLabelerTree();
    }

}
