/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common.node;

/**
 * Make your browser model nodes extend this interface to make the node itself
 * capable of defining what happens when objects are dropped on it.
 * 
 * The data can be any {@link Object} that has been dragged from the browser
 * itself or elsewhere. For the Eclipse workbench it is most likely a JFace
 * <code>ISelection</code>.
 * 
 * @author Tuukka Lehtonen
 */
public interface IDropTargetNode {

    /**
     * An object was dropped on this explorer node. React to the drop in any
     * manner seen fit.
     * 
     * @param data the dragged data.
     */
    void drop(Object data);

}
