/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.browsing.ui.common;

import org.simantics.browsing.ui.BuiltinKeys;
import org.simantics.browsing.ui.NodeContext;
import org.simantics.browsing.ui.NodeContext.ConstantKey;
import org.simantics.browsing.ui.NodeQueryManager;
import org.simantics.browsing.ui.Tester;
import org.simantics.browsing.ui.common.node.StandardNodes;

public final class Testers {

    /**
     * Simple pass all tester.
     */
    public static final Tester PASS = new Tester() {
        @Override
        public boolean test(NodeQueryManager manager, NodeContext context) {
            return true;
        }
        @Override
        public String toString() {
            return "PASS test";
        }
    };

    /**
     * Simple fail all tester.
     */
    public static final Tester FAIL = new Tester() {
        @Override
        public boolean test(NodeQueryManager manager, NodeContext context) {
            return false;
        }
        @Override
        public String toString() {
            return "FAIL test";
        }
    };

    /**
     * @param clazz
     * @return tester for checking whether node context input is an instance of
     *         the specified class
     */
    public static Tester instanceOfTester(final Class<?> clazz) {
        return new Tester() {
            @Override
            public boolean test(NodeQueryManager manager, NodeContext context) {
                return clazz.isInstance(context.getConstant(BuiltinKeys.INPUT));
            }
            @Override
            public String toString() {
                return "class " + clazz.getName() + " test";
            }
        };
    }

    public static Tester standardFunctionTester(final Object object) {
		return new Tester() {
			
			@Override
			public boolean test(NodeQueryManager manager, NodeContext context) {
				Object function = context.getConstant(StandardNodes.FUNCTION);
				return object.equals(function);
			}
			
		};
    }
    
    public static <T> Tester exists(final ConstantKey<T> key) {
		return new Tester() {
			
			@Override
			public boolean test(NodeQueryManager manager, NodeContext context) {
				return context.getConstant(key) != null;
			}
			
		};
    }

    public static Tester and(final Tester ... testers) {
		return new Tester() {
			
			@Override
			public boolean test(NodeQueryManager manager, NodeContext context) {
				for(Tester tester : testers) if(!tester.test(manager, context)) return false;
				return true;
			}
			
		};
    }
    
}
