/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.set.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableIntSet;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;

@Immutable
final class ImmutableIntSingletonSet
implements ImmutableIntSet,
Serializable {
    private static final long serialVersionUID = 1L;
    private final int element;

    ImmutableIntSingletonSet(int element) {
        this.element = element;
    }

    public ImmutableIntSet newWith(int element) {
        return IntSets.immutable.with(new int[]{this.element, element});
    }

    public ImmutableIntSet newWithout(int element) {
        return this.element == element ? IntSets.immutable.with() : this;
    }

    public ImmutableIntSet newWithAll(IntIterable elements) {
        return IntHashSet.newSet(elements).with(this.element).toImmutable();
    }

    public ImmutableIntSet newWithoutAll(IntIterable elements) {
        return elements.contains(this.element) ? IntSets.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public boolean contains(int value) {
        return this.element == value;
    }

    public boolean containsAll(IntIterable source) {
        IntIterator iterator = source.intIterator();
        while (iterator.hasNext()) {
            if (this.element == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(int ... source) {
        for (int value : source) {
            if (this.element == value) continue;
            return false;
        }
        return true;
    }

    public void forEach(IntProcedure procedure) {
        this.each(procedure);
    }

    public void each(IntProcedure procedure) {
        procedure.value(this.element);
    }

    public ImmutableIntSet select(IntPredicate predicate) {
        return predicate.accept(this.element) ? IntHashSet.newSetWith(this.element).toImmutable() : new IntHashSet().toImmutable();
    }

    public ImmutableIntSet reject(IntPredicate predicate) {
        return predicate.accept(this.element) ? new IntHashSet().toImmutable() : IntHashSet.newSetWith(this.element).toImmutable();
    }

    public <V> ImmutableSet<V> collect(IntToObjectFunction<? extends V> function) {
        return UnifiedSet.newSetWith(function.valueOf(this.element)).toImmutable();
    }

    public MutableIntList toList() {
        return IntArrayList.newListWith(this.element);
    }

    public int sizeDistinct() {
        return 1;
    }

    public int occurrencesOf(int item) {
        return this.element == item ? 1 : 0;
    }

    public void forEachWithOccurrences(IntIntProcedure intIntProcedure) {
        intIntProcedure.value(this.element, 1);
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return predicate.accept(this.element) ? this.element : ifNone;
    }

    public int count(IntPredicate predicate) {
        return predicate.accept(this.element) ? 1 : 0;
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return predicate.accept(this.element);
    }

    public long sum() {
        return this.element;
    }

    public int min() {
        return this.element;
    }

    public int max() {
        return this.element;
    }

    public int maxIfEmpty(int defaultValue) {
        return this.element;
    }

    public int minIfEmpty(int defaultValue) {
        return this.element;
    }

    public double average() {
        return this.element;
    }

    public double median() {
        return this.element;
    }

    public int[] toSortedArray() {
        return new int[]{this.element};
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newListWith(this.element);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return !predicate.accept(this.element);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return predicate.accept(this.element);
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.element);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IntSet)) {
            return false;
        }
        IntSet set = (IntSet)obj;
        if (set.size() != 1) {
            return false;
        }
        return set.contains(this.element);
    }

    public int hashCode() {
        return this.element;
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSetWith(this.element);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBagWith(this.element);
    }

    public IntSet freeze() {
        return this;
    }

    public ImmutableIntSet toImmutable() {
        return this;
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public int[] toArray() {
        return new int[]{this.element};
    }

    public String toString() {
        return '[' + this.makeString() + ']';
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.element));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public IntIterator intIterator() {
        return new UnmodifiableIntIterator((IntIterator)IntHashSet.newSetWith(this.element).intIterator());
    }
}

