/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.list.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.NoSuchElementException;
import net.jcip.annotations.Immutable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.ObjectShortIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.primitive.ImmutableShortList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.list.primitive.ShortList;
import org.eclipse.collections.api.set.primitive.MutableShortSet;
import org.eclipse.collections.impl.bag.mutable.primitive.ShortHashBag;
import org.eclipse.collections.impl.factory.primitive.ShortLists;
import org.eclipse.collections.impl.lazy.primitive.LazyShortIterableAdapter;
import org.eclipse.collections.impl.lazy.primitive.ReverseShortIterable;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.set.mutable.primitive.ShortHashSet;

@Immutable
final class ImmutableShortArrayList
implements ImmutableShortList,
Serializable {
    private static final long serialVersionUID = 1L;
    private final short[] items;

    private ImmutableShortArrayList(short[] newElements) {
        if (newElements.length <= 1) {
            throw new IllegalArgumentException("Use ShortLists.immutable.with() to instantiate an optimized collection");
        }
        this.items = newElements;
    }

    public static ImmutableShortArrayList newList(ShortIterable iterable) {
        return new ImmutableShortArrayList(iterable.toArray());
    }

    public static ImmutableShortArrayList newListWith(short ... elements) {
        short[] newArray = new short[elements.length];
        System.arraycopy(elements, 0, newArray, 0, elements.length);
        return new ImmutableShortArrayList(newArray);
    }

    public short get(int index) {
        return this.items[index];
    }

    public short getFirst() {
        return this.items[0];
    }

    public short getLast() {
        return this.items[this.items.length - 1];
    }

    public int indexOf(short value) {
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(short value) {
        for (int i = this.items.length - 1; i >= 0; --i) {
            if (this.items[i] != value) continue;
            return i;
        }
        return -1;
    }

    public ShortIterator shortIterator() {
        return new InternalShortIterator();
    }

    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    public void each(ShortProcedure procedure) {
        for (short item : this.items) {
            procedure.value(item);
        }
    }

    public void forEachWithIndex(ShortIntProcedure procedure) {
        for (int i = 0; i < this.items.length; ++i) {
            procedure.value(this.items[i], i);
        }
    }

    public int count(ShortPredicate predicate) {
        int count = 0;
        for (short item : this.items) {
            if (!predicate.accept(item)) continue;
            ++count;
        }
        return count;
    }

    public boolean anySatisfy(ShortPredicate predicate) {
        for (short item : this.items) {
            if (!predicate.accept(item)) continue;
            return true;
        }
        return false;
    }

    public boolean allSatisfy(ShortPredicate predicate) {
        for (short item : this.items) {
            if (predicate.accept(item)) continue;
            return false;
        }
        return true;
    }

    public boolean noneSatisfy(ShortPredicate predicate) {
        return !this.anySatisfy(predicate);
    }

    public ImmutableShortList select(ShortPredicate predicate) {
        return this.select(predicate, new ShortArrayList()).toImmutable();
    }

    public <R extends MutableShortCollection> R select(ShortPredicate predicate, R target) {
        for (short item : this.items) {
            if (!predicate.accept(item)) continue;
            target.add(item);
        }
        return target;
    }

    public ImmutableShortList reject(ShortPredicate predicate) {
        return this.reject(predicate, new ShortArrayList()).toImmutable();
    }

    public <R extends MutableShortCollection> R reject(ShortPredicate predicate, R target) {
        for (short item : this.items) {
            if (predicate.accept(item)) continue;
            target.add(item);
        }
        return target;
    }

    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        for (short item : this.items) {
            if (!predicate.accept(item)) continue;
            return item;
        }
        return ifNone;
    }

    public <V> ImmutableList<V> collect(ShortToObjectFunction<? extends V> function) {
        return this.collect(function, (Collection)((Object)FastList.newList(this.items.length))).toImmutable();
    }

    public <V, R extends Collection<V>> R collect(ShortToObjectFunction<? extends V> function, R target) {
        for (short item : this.items) {
            target.add((Object)function.valueOf(item));
        }
        return target;
    }

    public long sum() {
        long result = 0L;
        for (short item : this.items) {
            result += (long)item;
        }
        return result;
    }

    public short max() {
        short max = this.items[0];
        for (int i = 1; i < this.items.length; ++i) {
            short value = this.items[i];
            if (max >= value) continue;
            max = value;
        }
        return max;
    }

    public short maxIfEmpty(short defaultValue) {
        return this.max();
    }

    public short min() {
        short min = this.items[0];
        for (int i = 1; i < this.items.length; ++i) {
            short value = this.items[i];
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public short minIfEmpty(short defaultValue) {
        return this.min();
    }

    public double average() {
        return (double)this.sum() / (double)this.size();
    }

    public double median() {
        short[] sortedArray = this.toSortedArray();
        int middleIndex = sortedArray.length >> 1;
        if (sortedArray.length > 1 && (sortedArray.length & 1) == 0) {
            short first = sortedArray[middleIndex];
            short second = sortedArray[middleIndex - 1];
            return ((double)first + (double)second) / 2.0;
        }
        return sortedArray[middleIndex];
    }

    public short[] toSortedArray() {
        short[] array = this.toArray();
        Arrays.sort(array);
        return array;
    }

    public long dotProduct(ShortList list) {
        if (this.size() != list.size()) {
            throw new IllegalArgumentException("Lists used in dotProduct must be the same size");
        }
        long sum = 0L;
        for (int i = 0; i < this.size(); ++i) {
            sum += (long)this.items[i] * (long)list.get(i);
        }
        return sum;
    }

    public LazyShortIterable asReversed() {
        return ReverseShortIterable.adapt((ShortList)this);
    }

    public MutableShortList toSortedList() {
        return ShortArrayList.newList((ShortIterable)this).sortThis();
    }

    public int binarySearch(short value) {
        return Arrays.binarySearch(this.items, value);
    }

    public short[] toArray() {
        short[] newItems = new short[this.items.length];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        return newItems;
    }

    public boolean contains(short value) {
        for (short item : this.items) {
            if (item != value) continue;
            return true;
        }
        return false;
    }

    public boolean containsAll(short ... source) {
        for (short value : source) {
            if (this.contains(value)) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(ShortIterable source) {
        ShortIterator iterator = source.shortIterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public MutableShortList toList() {
        return ShortArrayList.newList((ShortIterable)this);
    }

    public MutableShortSet toSet() {
        return ShortHashSet.newSet((ShortIterable)this);
    }

    public MutableShortBag toBag() {
        return ShortHashBag.newBag((ShortIterable)this);
    }

    public LazyShortIterable asLazy() {
        return new LazyShortIterableAdapter((ShortIterable)this);
    }

    public ImmutableShortList toImmutable() {
        return this;
    }

    public ImmutableShortArrayList toReversed() {
        return ImmutableShortArrayList.newList((ShortIterable)this.asReversed());
    }

    public ImmutableShortList newWith(short element) {
        short[] newItems = new short[this.items.length + 1];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        newItems[this.items.length] = element;
        return new ImmutableShortArrayList(newItems);
    }

    public ImmutableShortList newWithout(short element) {
        int index = this.indexOf(element);
        if (index != -1) {
            short[] newItems = new short[this.items.length - 1];
            System.arraycopy(this.items, 0, newItems, 0, index);
            System.arraycopy(this.items, index + 1, newItems, index, this.items.length - index - 1);
            return ShortLists.immutable.with(newItems);
        }
        return this;
    }

    public ImmutableShortList newWithAll(ShortIterable elements) {
        short[] newItems = new short[this.items.length + elements.size()];
        System.arraycopy(this.items, 0, newItems, 0, this.items.length);
        int index = 0;
        ShortIterator iterator = elements.shortIterator();
        while (iterator.hasNext()) {
            newItems[this.items.length + index] = iterator.next();
            ++index;
        }
        return new ImmutableShortArrayList(newItems);
    }

    public ImmutableShortList newWithoutAll(ShortIterable elements) {
        MutableShortList mutableShortList = this.toList();
        mutableShortList.removeAll(elements);
        return mutableShortList.toImmutable();
    }

    public int size() {
        return this.items.length;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        for (int i = 0; i < this.items.length; ++i) {
            result = function.valueOf(result, this.items[i]);
        }
        return result;
    }

    public <T> T injectIntoWithIndex(T injectedValue, ObjectShortIntToObjectFunction<? super T, ? extends T> function) {
        Object result = injectedValue;
        for (int i = 0; i < this.items.length; ++i) {
            result = function.valueOf(result, this.items[i], i);
        }
        return result;
    }

    public boolean equals(Object otherList) {
        if (otherList == this) {
            return true;
        }
        if (!(otherList instanceof ShortList)) {
            return false;
        }
        ShortList list = (ShortList)otherList;
        if (this.items.length != list.size()) {
            return false;
        }
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == list.get(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        for (short item : this.items) {
            hashCode = 31 * hashCode + item;
        }
        return hashCode;
    }

    public String toString() {
        return this.makeString("[", ", ", "]");
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            for (int i = 0; i < this.items.length; ++i) {
                if (i > 0) {
                    appendable.append(separator);
                }
                short value = this.items[i];
                appendable.append(String.valueOf(value));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ImmutableShortList distinct() {
        ShortArrayList target = new ShortArrayList();
        ShortHashSet seenSoFar = new ShortHashSet(this.size());
        for (short each : this.items) {
            if (!seenSoFar.add(each)) continue;
            target.add(each);
        }
        return target.toImmutable();
    }

    public ImmutableShortList subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("subList not yet implemented!");
    }

    private class InternalShortIterator
    implements ShortIterator {
        private int currentIndex;

        private InternalShortIterator() {
        }

        public boolean hasNext() {
            return this.currentIndex != ImmutableShortArrayList.this.items.length;
        }

        public short next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            short next = ImmutableShortArrayList.this.items[this.currentIndex];
            ++this.currentIndex;
            return next;
        }
    }
}

