/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bimap.mutable;

import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bimap.ImmutableBiMap;
import org.eclipse.collections.api.bimap.MutableBiMap;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.multimap.set.MutableSetMultimap;
import org.eclipse.collections.api.partition.set.PartitionMutableSet;
import org.eclipse.collections.api.set.MutableSet;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.collection.mutable.SynchronizedMutableCollection;
import org.eclipse.collections.impl.list.fixed.ArrayAdapter;
import org.eclipse.collections.impl.map.AbstractSynchronizedMapIterable;
import org.eclipse.collections.impl.map.mutable.SynchronizedBiMapSerializationProxy;
import org.eclipse.collections.impl.set.mutable.SynchronizedMutableSet;
import org.eclipse.collections.impl.utility.LazyIterate;

public class SynchronizedBiMap<K, V>
extends AbstractSynchronizedMapIterable<K, V>
implements MutableBiMap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;

    protected SynchronizedBiMap(MutableBiMap<K, V> delegate) {
        super(delegate);
    }

    protected SynchronizedBiMap(MutableBiMap<K, V> delegate, Object lock) {
        super(delegate, lock);
    }

    public static <K, V> SynchronizedBiMap<K, V> of(MutableBiMap<K, V> map) {
        if (map == null) {
            throw new IllegalArgumentException("cannot create a SynchronizedBiMap for null");
        }
        return new SynchronizedBiMap<K, V>(map);
    }

    @Override
    protected MutableBiMap<K, V> getDelegate() {
        return (MutableBiMap)super.getDelegate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V forcePut(K key, V value) {
        Object object = this.lock;
        synchronized (object) {
            return (V)this.getDelegate().forcePut(key, value);
        }
    }

    public MutableBiMap<K, V> asSynchronized() {
        return this;
    }

    public MutableBiMap<K, V> asUnmodifiable() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".asUnmodifiable() not implemented yet");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBiMap<K, V> clone() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedBiMap.of(this.getDelegate().clone());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBiMap<K, V> tap(Procedure<? super V> procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.getDelegate().tap(procedure);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <K2, V2> MutableBiMap<K2, V2> collect(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> MutableBiMap<K, R> collectValues(Function2<? super K, ? super V, ? extends R> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collectValues(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSet<V> select(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBiMap<K, V> select(Predicate2<? super K, ? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> MutableSet<V> selectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().selectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <S> MutableSet<S> selectInstancesOf(Class<S> clazz) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().selectInstancesOf(clazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSet<V> reject(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBiMap<K, V> reject(Predicate2<? super K, ? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> MutableSet<V> rejectWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().rejectWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PartitionMutableSet<V> partition(Predicate<? super V> predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().partition(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P> PartitionMutableSet<V> partitionWith(Predicate2<? super V, ? super P> predicate, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().partitionWith(predicate, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1> RichIterable<V1> collect(Function<? super V, ? extends V1> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BooleanIterable collectBoolean(BooleanFunction<? super V> booleanFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collectBoolean(booleanFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteIterable collectByte(ByteFunction<? super V> byteFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collectByte(byteFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CharIterable collectChar(CharFunction<? super V> charFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collectChar(charFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DoubleIterable collectDouble(DoubleFunction<? super V> doubleFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collectDouble(doubleFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FloatIterable collectFloat(FloatFunction<? super V> floatFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collectFloat(floatFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IntIterable collectInt(IntFunction<? super V> intFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collectInt(intFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LongIterable collectLong(LongFunction<? super V> longFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collectLong(longFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShortIterable collectShort(ShortFunction<? super V> shortFunction) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collectShort(shortFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <P, V1> RichIterable<V1> collectWith(Function2<? super V, ? super P, ? extends V1> function, P parameter) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collectWith(function, parameter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1> RichIterable<V1> collectIf(Predicate<? super V> predicate, Function<? super V, ? extends V1> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().collectIf(predicate, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1> RichIterable<V1> flatCollect(Function<? super V, ? extends Iterable<V1>> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().flatCollect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1> MutableSetMultimap<V1, V> groupBy(Function<? super V, ? extends V1> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().groupBy(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V1> MutableSetMultimap<V1, V> groupByEach(Function<? super V, ? extends Iterable<V1>> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().groupByEach(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableSetMultimap<V, K> flip() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().flip();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBiMap<K, V> newEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().newEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBiMap<V, K> inverse() {
        Object object = this.lock;
        synchronized (object) {
            return new SynchronizedBiMap<K, V>(this.getDelegate().inverse(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBiMap<V, K> flipUniqueValues() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().flipUniqueValues();
        }
    }

    public RichIterable<K> keysView() {
        return LazyIterate.adapt(this.keySet());
    }

    public RichIterable<V> valuesView() {
        return LazyIterate.adapt(this.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableBiMap<K, V> toImmutable() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().toImmutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public MutableSet<Pair<V, Integer>> zipWithIndex() {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().zipWithIndex();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <VV> MutableBiMap<VV, V> groupByUniqueKey(Function<? super V, ? extends VV> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().groupByUniqueKey(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public <S> MutableSet<Pair<V, S>> zip(Iterable<S> that) {
        Object object = this.lock;
        synchronized (object) {
            return this.getDelegate().zip(that);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBiMap<K, V> withKeyValue(K key, V value) {
        Object object = this.lock;
        synchronized (object) {
            this.getDelegate().put(key, value);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBiMap<K, V> withAllKeyValues(Iterable<? extends Pair<? extends K, ? extends V>> keyValues) {
        Object object = this.lock;
        synchronized (object) {
            for (Pair<K, V> pair : keyValues) {
                this.getDelegate().put(pair.getOne(), pair.getTwo());
            }
            return this;
        }
    }

    public MutableBiMap<K, V> withAllKeyValueArguments(Pair<? extends K, ? extends V> ... keyValuePairs) {
        return this.withAllKeyValues((Iterable<? extends Pair<? extends K, ? extends V>>)((Object)ArrayAdapter.adapt(keyValuePairs)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBiMap<K, V> withoutKey(K key) {
        Object object = this.lock;
        synchronized (object) {
            this.getDelegate().remove(key);
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableBiMap<K, V> withoutAllKeys(Iterable<? extends K> keys) {
        Object object = this.lock;
        synchronized (object) {
            for (K key : keys) {
                this.getDelegate().removeKey(key);
            }
            return this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<K> keySet() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedMutableSet.of(this.getDelegate().keySet(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<V> values() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedMutableCollection.of(this.getDelegate().values(), this.lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Map.Entry<K, V>> entrySet() {
        Object object = this.lock;
        synchronized (object) {
            return SynchronizedMutableSet.of(this.getDelegate().entrySet(), this.lock);
        }
    }

    protected Object writeReplace() {
        return new SynchronizedBiMapSerializationProxy<K, V>(this.getDelegate());
    }
}

