/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.bag.mutable.primitive;

import net.jcip.annotations.NotThreadSafe;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.tuple.primitive.IntIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.SynchronizedIntBag;
import org.eclipse.collections.impl.collection.mutable.primitive.AbstractUnmodifiableIntCollection;
import org.eclipse.collections.impl.factory.primitive.IntBags;

@NotThreadSafe
public final class UnmodifiableIntBag
extends AbstractUnmodifiableIntCollection
implements MutableIntBag {
    private static final long serialVersionUID = 1L;

    public UnmodifiableIntBag(MutableIntBag bag) {
        super((MutableIntCollection)bag);
    }

    private MutableIntBag getMutableIntBag() {
        return (MutableIntBag)this.getIntCollection();
    }

    @Override
    public UnmodifiableIntBag with(int element) {
        throw new UnsupportedOperationException("Cannot call with() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableIntBag without(int element) {
        throw new UnsupportedOperationException("Cannot call without() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableIntBag withAll(IntIterable elements) {
        throw new UnsupportedOperationException("Cannot call withAll() on " + this.getClass().getSimpleName());
    }

    @Override
    public UnmodifiableIntBag withoutAll(IntIterable elements) {
        throw new UnsupportedOperationException("Cannot call withoutAll() on " + this.getClass().getSimpleName());
    }

    public void addOccurrences(int item, int occurrences) {
        throw new UnsupportedOperationException("Cannot call addOccurrences() on " + this.getClass().getSimpleName());
    }

    public boolean removeOccurrences(int item, int occurrences) {
        throw new UnsupportedOperationException("Cannot call removeOccurrences() on " + this.getClass().getSimpleName());
    }

    public int sizeDistinct() {
        return this.getMutableIntBag().sizeDistinct();
    }

    public int occurrencesOf(int item) {
        return this.getMutableIntBag().occurrencesOf(item);
    }

    public void forEachWithOccurrences(IntIntProcedure procedure) {
        this.getMutableIntBag().forEachWithOccurrences(procedure);
    }

    public MutableIntBag selectByOccurrences(IntPredicate predicate) {
        return this.getMutableIntBag().selectByOccurrences(predicate);
    }

    public MutableList<IntIntPair> topOccurrences(int count) {
        return this.getMutableIntBag().topOccurrences(count);
    }

    public MutableList<IntIntPair> bottomOccurrences(int count) {
        return this.getMutableIntBag().bottomOccurrences(count);
    }

    public MutableIntBag select(IntPredicate predicate) {
        return this.getMutableIntBag().select(predicate);
    }

    public MutableIntBag reject(IntPredicate predicate) {
        return this.getMutableIntBag().reject(predicate);
    }

    public <V> MutableBag<V> collect(IntToObjectFunction<? extends V> function) {
        return this.getMutableIntBag().collect(function);
    }

    public boolean equals(Object otherBag) {
        return this.getMutableIntBag().equals(otherBag);
    }

    public int hashCode() {
        return this.getMutableIntBag().hashCode();
    }

    public MutableIntBag asUnmodifiable() {
        return this;
    }

    public MutableIntBag asSynchronized() {
        return new SynchronizedIntBag(this);
    }

    public ImmutableIntBag toImmutable() {
        return IntBags.immutable.withAll((IntIterable)this);
    }
}

