/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.spreadsheet.graph;

import gnu.trove.iterator.TObjectIntIterator;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.simantics.Simantics;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.binding.mutable.Variant;
import org.simantics.databoard.type.Datatype;
import org.simantics.databoard.util.binary.RandomAccessBinary;
import org.simantics.datatypes.DatatypeResource;
import org.simantics.datatypes.literal.Font;
import org.simantics.datatypes.literal.RGB;
import org.simantics.datatypes.utils.BTree;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.BinaryRead;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.LiteralFileUtil;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.exception.ServiceException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.procedure.Listener;
import org.simantics.db.request.Read;
import org.simantics.db.request.ReadInterface;
import org.simantics.db.request.Write;
import org.simantics.db.service.ClusteringSupport;
import org.simantics.layer0.Layer0;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function;
import org.simantics.scl.runtime.tuple.Tuple0;
import org.simantics.scl.runtime.tuple.Tuple2;
import org.simantics.simulator.toolkit.StandardRealm;
import org.simantics.spreadsheet.CellEditor;
import org.simantics.spreadsheet.ExternalRef;
import org.simantics.spreadsheet.OperationMode;
import org.simantics.spreadsheet.Range;
import org.simantics.spreadsheet.SpreadsheetVisitor;
import org.simantics.spreadsheet.Spreadsheets;
import org.simantics.spreadsheet.Transaction;
import org.simantics.spreadsheet.graph.EvaluateAll;
import org.simantics.spreadsheet.graph.InvalidateAll;
import org.simantics.spreadsheet.graph.SpreadsheetSessionManager;
import org.simantics.spreadsheet.graph.synchronization.SpreadsheetSynchronizationEventHandler;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.spreadsheet.solver.SpreadsheetBook;
import org.simantics.spreadsheet.solver.SpreadsheetCell;
import org.simantics.spreadsheet.solver.SpreadsheetEngine;
import org.simantics.spreadsheet.solver.SpreadsheetLine;
import org.simantics.spreadsheet.solver.SpreadsheetStyle;
import org.simantics.spreadsheet.util.SpreadsheetUtils;
import org.simantics.structural.synchronization.client.Synchronizer;
import org.simantics.structural.synchronization.protocol.SynchronizationEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpreadsheetGraphUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpreadsheetGraphUtils.class);
    public static final String SPREADSHEET_TRANSACTION = "spreadsheetTransaction";

    public static File extractInitialCondition(ReadGraph graph, Resource ic) throws DatabaseException, IOException {
        SpreadsheetResource SR = SpreadsheetResource.getInstance((ReadGraph)graph);
        File temp = Simantics.getTempfile((String)"excel", (String)"ic");
        LiteralFileUtil.copyRandomAccessBinaryToFile((ReadGraph)graph, (Resource)ic, (Resource)SR.InitialCondition_bytes, (File)temp);
        if (temp.length() == 0L) {
            throw new FileNotFoundException("Snapshot file does not exist.\nThis seems to be a database bug that manifests as total loss of state file data.\nThis error prevents the program from crashing.");
        }
        return temp;
    }

    public static RandomAccessBinary getOrCreateRandomAccessBinary(WriteGraph graph, Resource initialCondition) throws DatabaseException, IOException {
        SpreadsheetResource SR = SpreadsheetResource.getInstance((ReadGraph)graph);
        Resource literal = graph.getPossibleObject(initialCondition, SR.InitialCondition_bytes);
        if (literal != null) {
            RandomAccessBinary rab = graph.getRandomAccessBinary(literal);
            rab.position(0L);
            rab.removeBytes(rab.length(), RandomAccessBinary.ByteSide.Right);
            return rab;
        }
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        ClusteringSupport cs = (ClusteringSupport)graph.getService(ClusteringSupport.class);
        literal = graph.newResource(cs.createCluster());
        graph.claim(literal, L0.InstanceOf, null, L0.ByteArray);
        graph.claim(initialCondition, SR.InitialCondition_bytes, SR.InitialCondition_bytes_Inverse, literal);
        return graph.createRandomAccessBinary(literal, (Datatype)Bindings.BYTE_ARRAY.type(), null);
    }

    public static Resource saveInitialCondition(WriteGraph graph, Variable run, Resource container, String name) throws DatabaseException {
        String sessionName = run.getParent((ReadGraph)graph).getURI((ReadGraph)graph);
        Resource bookResource = run.getRepresents((ReadGraph)graph);
        StandardRealm realm = SpreadsheetSessionManager.getInstance().getOrCreateRealm((ReadGraph)graph, sessionName);
        SpreadsheetBook book = (SpreadsheetBook)realm.getEngine();
        try {
            File temp = Simantics.getTempfile((String)"excel", (String)"ic");
            System.err.println("Saving initial condition to " + temp.getAbsolutePath());
            FileOutputStream fileOut = new FileOutputStream(temp);
            ObjectOutputStream out = new ObjectOutputStream(fileOut);
            out.writeObject(book);
            out.close();
            fileOut.close();
            Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
            SpreadsheetResource SR = SpreadsheetResource.getInstance((ReadGraph)graph);
            Resource ic = graph.newResource();
            graph.claim(ic, L0.InstanceOf, SR.InitialCondition);
            graph.addLiteral(ic, L0.HasName, L0.NameOf, L0.String, (Object)name, (Binding)Bindings.STRING);
            RandomAccessBinary rab = SpreadsheetGraphUtils.getOrCreateRandomAccessBinary(graph, ic);
            LiteralFileUtil.copyRandomAccessBinaryFromFile((File)temp, (RandomAccessBinary)rab);
            graph.claim(container, L0.ConsistsOf, L0.PartOf, ic);
            graph.deny(bookResource, SR.HasInitialCondition);
            graph.claim(bookResource, SR.HasInitialCondition, ic);
            graph.claim(ic, SR.InitialCondition_ConditionOf, bookResource);
            SpreadsheetGraphUtils.setDefaultInitialConditionForBook(graph, bookResource, ic);
            return ic;
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static void setDefaultInitialConditionForBook(WriteGraph graph, Resource book, Resource ic) throws ServiceException {
        SpreadsheetResource SR = SpreadsheetResource.getInstance((ReadGraph)graph);
        graph.deny(book, SR.Book_HasDefaultInitialCondition);
        graph.claim(ic, SR.InitialCondition_DefaultConditionOf, book);
    }

    public static void evaluateAll(ReadGraph graph, Variable run) throws DatabaseException {
        String sessionName = run.getParent(graph).getURI(graph);
        StandardRealm realm = SpreadsheetSessionManager.getInstance().getOrCreateRealm(graph, sessionName);
        SpreadsheetBook book = (SpreadsheetBook)realm.getEngine();
        book.accept((SpreadsheetVisitor)new EvaluateAll(book));
    }

    public static void invalidateAll(ReadGraph graph, Variable run) throws DatabaseException {
        String sessionName = run.getParent(graph).getURI(graph);
        StandardRealm realm = SpreadsheetSessionManager.getInstance().getOrCreateRealm(graph, sessionName);
        SpreadsheetBook book = (SpreadsheetBook)realm.getEngine();
        book.accept((SpreadsheetVisitor)new InvalidateAll());
        realm.getNodeManager().refreshVariables();
    }

    public static boolean fullSynchronization(ReadGraph graph, Variable run) throws DatabaseException {
        return SpreadsheetGraphUtils.partialSynchronization(graph, run, null);
    }

    public static boolean partialSynchronization(ReadGraph graph, Variable run, TObjectIntHashMap<Variable> changeFlags) throws DatabaseException {
        Synchronizer synchronizer = new Synchronizer(graph);
        String sessionName = run.getParent(graph).getURI(graph);
        Resource bookResource = run.getRepresents(graph);
        Variable configuration = Variables.getVariable((ReadGraph)graph, (Resource)bookResource);
        StandardRealm realm = SpreadsheetSessionManager.getInstance().getOrCreateRealm(graph, sessionName);
        SpreadsheetBook book = (SpreadsheetBook)realm.getEngine();
        SpreadsheetSynchronizationEventHandler handler = new SpreadsheetSynchronizationEventHandler(graph, book);
        if (changeFlags == null) {
            synchronizer.fullSynchronization(configuration, (SynchronizationEventHandler)handler);
        } else {
            TObjectIntIterator iter = changeFlags.iterator();
            iter.advance();
            Variable row = (Variable)iter.key();
            Variable rowParent = row.getParent(graph);
            while (!rowParent.equals(configuration)) {
                changeFlags.put((Object)rowParent, 1);
                rowParent = rowParent.getParent(graph);
            }
            changeFlags.put((Object)configuration, 1);
            synchronizer.partialSynchronization(configuration, (SynchronizationEventHandler)handler, changeFlags);
        }
        realm.getNodeManager().fireNodeListeners();
        return handler.getDidChanges();
    }

    public static Variable findCell(ReadGraph graph, Variable run, String reference) throws DatabaseException {
        int pos = reference.indexOf("!");
        String sheetName = reference.substring(0, pos);
        String cellName = reference.substring(pos + 1);
        String sessionName = run.getParent(graph).getURI(graph);
        StandardRealm realm = SpreadsheetSessionManager.getInstance().getOrCreateRealm(graph, sessionName);
        SpreadsheetBook book = (SpreadsheetBook)realm.getEngine();
        SpreadsheetEngine engine = book.getEngine(sheetName);
        if (engine == null) {
            return null;
        }
        Range r = Spreadsheets.decodeCellAbsolute((String)cellName);
        SpreadsheetLine line = engine.getLine(r.startRow);
        if (line == null) {
            return null;
        }
        String path = line.getPath();
        if (path == null) {
            return null;
        }
        Variable lineVariable = run.browse(graph, path);
        if (lineVariable == null) {
            return null;
        }
        return lineVariable.getChild(graph, cellName);
    }

    public static List<Variable> possibleConfigurationCellVariables(ReadGraph graph, Variable sheet, Range range) throws DatabaseException {
        List<Variable> rowVariables = SpreadsheetGraphUtils.possibleConfigurationLineVariables(graph, sheet, range);
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (Variable variable : rowVariables) {
            Collection children = variable.getChildren(graph);
            for (Variable child : children) {
                if (!SpreadsheetGraphUtils.variableInRange(graph, child, range)) continue;
                result.add(child);
            }
        }
        return result;
    }

    public static Map<Integer, Resource> possibleConfigurationLineResources(ReadGraph graph, Variable sheet, Range range) throws DatabaseException {
        Variable lines = sheet.getPossibleChild(graph, "Lines");
        if (lines == null) {
            throw new DatabaseException("Invalid input variable " + sheet.getURI(graph));
        }
        Resource linesR = lines.getRepresents(graph);
        BTree bt = new BTree(graph, linesR);
        List tuples = bt.searchRangeBTree(graph, Variant.ofInstance((Object)range.startRow), Variant.ofInstance((Object)range.endRow));
        HashMap<Integer, Resource> result = new HashMap<Integer, Resource>(tuples.size());
        for (Tuple2 tuple : tuples) {
            Integer lineNumber = (Integer)((Variant)tuple.c0).getValue();
            Resource resource = (Resource)tuple.c1;
            result.put(lineNumber, resource);
        }
        return result;
    }

    public static List<Variable> possibleConfigurationLineVariables(ReadGraph graph, Variable sheet, Range range) throws DatabaseException {
        Map<Integer, Resource> rows = SpreadsheetGraphUtils.possibleConfigurationLineResources(graph, sheet, range);
        ArrayList<Variable> result = new ArrayList<Variable>(rows.size());
        for (Resource row : rows.values()) {
            Variable lineVar = Variables.getPossibleVariable((ReadGraph)graph, (Resource)row);
            if (lineVar == null) continue;
            result.add(lineVar);
        }
        return result;
    }

    public static List<Variable> possibleRunLineVariables(ReadGraph graph, Variable sheetRun, Range range) throws DatabaseException {
        Variable run = sheetRun.getParent(graph);
        String sheetName = sheetRun.getName(graph);
        String sessionName = run.getParent(graph).getURI(graph);
        StandardRealm realm = SpreadsheetSessionManager.getInstance().getOrCreateRealm(graph, sessionName);
        SpreadsheetBook book = (SpreadsheetBook)realm.getEngine();
        SpreadsheetEngine engine = book.getEngine(sheetName);
        if (engine == null) {
            return null;
        }
        ArrayList<Variable> result = new ArrayList<Variable>();
        int end = range.endRow < engine.lines.getMaxRow() ? range.endRow : engine.lines.getMaxRow();
        int i = range.startRow;
        while (i <= end) {
            SpreadsheetLine line = engine.getLine(i);
            if (line != null) {
                Variable lineVariable;
                String path = line.getPath();
                path = line.getPath();
                if (path != null && (lineVariable = run.browse(graph, path)) != null) {
                    result.add(lineVariable);
                }
            }
            ++i;
        }
        return result;
    }

    public static List<Variable> possibleRunCellVariables(ReadGraph graph, Variable sheetRun, Range range) throws DatabaseException {
        List<Variable> runLineVariable = SpreadsheetGraphUtils.possibleRunLineVariables(graph, sheetRun, range);
        ArrayList<Variable> result = new ArrayList<Variable>();
        for (Variable variable : runLineVariable) {
            for (Variable child : variable.getChildren(graph)) {
                if (!SpreadsheetGraphUtils.variableInRange(graph, child, range)) continue;
                result.add(child);
            }
        }
        return result;
    }

    private static boolean variableInRange(ReadGraph graph, Variable child, Range range) throws DatabaseException {
        String name = child.getName(graph);
        Range childRange = Spreadsheets.decodeCellAbsolute((String)name);
        return childRange != null && range.contains(childRange);
    }

    public static Map<Integer, Resource> createConfigurationLineResources(WriteGraph graph, Variable sheet, Range range) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
        Variable lines = sheet.getPossibleChild((ReadGraph)graph, "Lines");
        if (lines == null) {
            throw new DatabaseException("Invalid input variable " + sheet.getURI((ReadGraph)graph));
        }
        Resource linesR = lines.getRepresents((ReadGraph)graph);
        BTree bt = new BTree((ReadGraph)graph, linesR);
        HashMap<Integer, Resource> result = new HashMap<Integer, Resource>();
        int lineNumber = range.startRow;
        while (lineNumber <= range.endRow) {
            Resource line = graph.newResource();
            graph.claim(line, L0.InstanceOf, null, SHEET.Line);
            graph.claimLiteral(line, L0.HasName, L0.NameOf, L0.String, (Object)("Row" + lineNumber), (Binding)Bindings.STRING);
            bt.insertBTree(graph, Variant.ofInstance((Object)lineNumber), line);
            result.put(lineNumber, line);
            ++lineNumber;
        }
        return result;
    }

    public static List<Variable> getOrCreateConfigurationCellVariables(WriteGraph graph, Variable sheet, Range range) throws DatabaseException {
        List<Variable> cells;
        List<Variable> rows = SpreadsheetGraphUtils.possibleConfigurationLineVariables((ReadGraph)graph, sheet, range);
        if (rows.isEmpty()) {
            SpreadsheetGraphUtils.createConfigurationLineResources(graph, sheet, range);
            rows = SpreadsheetGraphUtils.possibleConfigurationLineVariables((ReadGraph)graph, sheet, range);
        }
        if ((cells = SpreadsheetGraphUtils.possibleConfigurationCellVariables((ReadGraph)graph, sheet, range)).isEmpty()) {
            Iterator<Variable> rowIterator = rows.iterator();
            int rowNumber = range.startRow;
            while (rowNumber <= range.endRow) {
                Variable row = rowIterator.next();
                int colNumber = range.startColumn;
                while (colNumber <= range.endColumn) {
                    String location = Spreadsheets.cellName((int)rowNumber, (int)colNumber);
                    SpreadsheetGraphUtils.defaultCreateCell(graph, row, location, new Variant((Binding)Bindings.STRING, (Object)""));
                    ++colNumber;
                }
                ++rowNumber;
            }
        }
        if ((cells = SpreadsheetGraphUtils.possibleConfigurationCellVariables((ReadGraph)graph, sheet, range)).isEmpty()) {
            throw new DatabaseException("Unexpected problem while creating spreadsheet cell at '" + range + "'");
        }
        return cells;
    }

    private static void defaultCreateCell(WriteGraph graph, Variable parent, String location, Variant value) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
        Resource container = parent.getRepresents((ReadGraph)graph);
        Resource cell = graph.newResource();
        graph.claim(cell, L0.InstanceOf, null, SHEET.TextCell);
        graph.addLiteral(cell, L0.HasName, L0.NameOf, L0.String, (Object)location, (Binding)Bindings.STRING);
        graph.addLiteral(cell, SHEET.Cell_content, SHEET.Cell_content_Inverse, L0.Variant, (Object)value, (Binding)Bindings.VARIANT);
        graph.claim(cell, L0.PartOf, container);
        Resource book = Variables.getContext((ReadGraph)graph, (Variable)parent).getRepresents((ReadGraph)graph);
        Collection objects = (Collection)graph.sync((ReadInterface)new ObjectsWithType(book, L0.ConsistsOf, SHEET.Style));
        int styleId = SpreadsheetStyle.empty().getStyleId();
        Resource style = null;
        for (Resource possibleStyle : objects) {
            int possibleStyleId = (Integer)graph.getRelatedValue2(possibleStyle, SHEET.Style_id, (Binding)Bindings.INTEGER);
            if (possibleStyleId != styleId) continue;
            style = possibleStyle;
            break;
        }
        if (style == null) {
            style = graph.newResource();
            graph.claim(style, L0.InstanceOf, null, SHEET.Style);
            graph.claim(style, L0.PartOf, book);
            int id = objects.size();
            graph.claimLiteral(style, L0.HasName, (Object)("Style_" + id));
            graph.claimLiteral(style, SHEET.Style_id, (Object)styleId, (Binding)Bindings.INTEGER);
        }
        graph.claim(cell, SHEET.Cell_HasStyle, style);
        Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Created cell on location " + location + " with value " + value.toString()));
    }

    public static Resource createStyle(WriteGraph graph, Resource book, SpreadsheetStyle sstyle) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SpreadsheetResource SR = SpreadsheetResource.getInstance((ReadGraph)graph);
        Resource style = graph.newResource();
        graph.claim(style, L0.InstanceOf, null, SR.Style);
        graph.claim(style, L0.PartOf, book);
        int styleId = sstyle.getStyleId();
        String styleName = sstyle.name;
        graph.claimLiteral(style, L0.HasName, (Object)styleName);
        graph.claimLiteral(style, SR.Style_id, (Object)styleId, (Binding)Bindings.INTEGER);
        DatatypeResource DATATYPES = DatatypeResource.getInstance((ReadGraph)graph);
        if (sstyle.foreground != null) {
            graph.claimLiteral(style, SR.Cell_foreground, DATATYPES.RGB_Integer, (Object)sstyle.foreground, RGB.Integer.BINDING);
        }
        if (sstyle.background != null) {
            graph.claimLiteral(style, SR.Cell_background, DATATYPES.RGB_Integer, (Object)sstyle.background, RGB.Integer.BINDING);
        }
        if (sstyle.align != -1) {
            graph.claimLiteral(style, SR.Cell_align, (Object)sstyle.align, (Binding)Bindings.INTEGER);
        }
        if (sstyle.font != null) {
            graph.claimLiteral(style, SR.Cell_font, DATATYPES.Font, (Object)sstyle.font, Font.BINDING);
        }
        if (sstyle.border != -1) {
            graph.claimLiteral(style, SR.Cell_border, (Object)sstyle.border);
        }
        if (sstyle.formatString != null && !sstyle.formatString.isEmpty()) {
            graph.claimLiteral(style, SR.Cell_formatString, (Object)sstyle.formatString, (Binding)Bindings.STRING);
        }
        if (sstyle.formatIndex != -1) {
            graph.claimLiteral(style, SR.Cell_formatIndex, (Object)sstyle.formatIndex, (Binding)Bindings.INTEGER);
        }
        return style;
    }

    public static Resource createBook(WriteGraph graph, Resource parent, String name) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance((ReadGraph)graph);
        SpreadsheetResource SR = SpreadsheetResource.getInstance((ReadGraph)graph);
        Resource book = graph.newResource();
        graph.claim(book, L0.InstanceOf, SR.Book);
        graph.claimLiteral(book, L0.HasName, L0.NameOf, L0.String, (Object)name, (Binding)Bindings.STRING);
        graph.claim(parent, L0.ConsistsOf, book);
        return book;
    }

    public static Variable constructAndInitializeRunVariable(WriteGraph graph, Resource root) throws DatabaseException {
        Variable run = SpreadsheetUtils.getBookVariable((ReadGraph)graph, (Resource)root);
        SpreadsheetGraphUtils.fullSynchronization((ReadGraph)graph, run);
        SpreadsheetGraphUtils.evaluateAll((ReadGraph)graph, run);
        SpreadsheetGraphUtils.saveInitialCondition(graph, run, root, "Initial");
        return run;
    }

    public static Variant extRefVariable(ReadGraph graph, Variable var) throws DatabaseException {
        return new Variant(Bindings.VOID, (Object)new ExternalRefVariable(graph, var));
    }

    public static Variant extRefActiveVariable(ReadGraph graph, Variable var) throws DatabaseException {
        return new Variant(Bindings.VOID, (Object)new ExternalRefActiveVariable(graph, var));
    }

    public static CellEditor cellEditor(ReadGraph graph, Resource sheet) throws DatabaseException {
        SpreadsheetResource SHEET = SpreadsheetResource.getInstance((ReadGraph)graph);
        Variable sheetVariable = Variables.getVariable((ReadGraph)graph, (Resource)sheet);
        return (CellEditor)sheetVariable.getPropertyValue(graph, SHEET.cellEditor);
    }

    public static Object syncExec(CellEditor editor, OperationMode mode, Function fun) throws InterruptedException {
        Transaction tr = editor.startTransaction(mode);
        SCLContext context = SCLContext.getCurrent();
        Transaction oldTransaction = (Transaction)context.put((Object)SPREADSHEET_TRANSACTION, (Object)tr);
        Object result = null;
        try {
            result = fun.apply((Object)Tuple0.INSTANCE);
        }
        finally {
            tr.commit();
            context.put((Object)SPREADSHEET_TRANSACTION, (Object)oldTransaction);
        }
        return result;
    }

    public static int cellColumn(ReadGraph graph, Variable cell) {
        if (cell instanceof StandardGraphChildVariable) {
            StandardGraphChildVariable sgcv = (StandardGraphChildVariable)cell;
            SpreadsheetCell sc = (SpreadsheetCell)sgcv.node.node;
            return sc.getColumn();
        }
        throw new IllegalStateException("Expected StandardGraphChildVariable, got " + cell.getClass().getName());
    }

    static class ExternalRefActiveVariable
    implements ExternalRef {
        private final String uri;

        public ExternalRefActiveVariable(ReadGraph graph, Variable variable) throws DatabaseException {
            this.uri = variable.getURI(graph);
        }

        public void listen(final Object context, final ExternalRef.ExternalRefListener listener) {
            Simantics.getSession().asyncRequest((Read)new BinaryRead<String, String, Variant>((String)context, this.uri){

                public Variant perform(ReadGraph graph) throws DatabaseException {
                    Variable contextVariable = Variables.getVariable((ReadGraph)graph, (String)((String)this.parameter));
                    Variable configVariable = Variables.getVariable((ReadGraph)graph, (String)((String)this.parameter2));
                    Variable activeVariable = Variables.switchPossibleContext((ReadGraph)graph, (Variable)configVariable, (Resource)contextVariable.getRepresents(graph));
                    if (activeVariable == null) {
                        return Variant.ofInstance((Object)("Could not resolve " + configVariable.getURI(graph) + " for " + contextVariable.getURI(graph)));
                    }
                    return activeVariable.getVariantValue(graph);
                }
            }, (Listener)new Listener<Variant>(){

                public void execute(Variant result) {
                    listener.newValue(result);
                }

                public void exception(Throwable t) {
                    LOGGER.error("Error while evaluating variable value, context = " + context + " uri=" + uri, t);
                }

                public boolean isDisposed() {
                    return listener.isDisposed();
                }
            });
        }

        public void modify(final Object context, final Variant newValue) {
            Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Variable contextVariable = Variables.getVariable((ReadGraph)graph, (String)((String)context));
                    Variable configVariable = Variables.getVariable((ReadGraph)graph, (String)uri);
                    Variable activeVariable = Variables.switchPossibleContext((ReadGraph)graph, (Variable)configVariable, (Resource)contextVariable.getRepresents((ReadGraph)graph));
                    if (activeVariable == null) {
                        return;
                    }
                    activeVariable.setValue(graph, newValue.getValue(), newValue.getBinding());
                }
            });
        }
    }

    static class ExternalRefVariable
    implements ExternalRef {
        private final String uri;

        public ExternalRefVariable(ReadGraph graph, Variable variable) throws DatabaseException {
            this.uri = variable.getURI(graph);
        }

        public void listen(Object context, final ExternalRef.ExternalRefListener listener) {
            Simantics.getSession().asyncRequest((Read)new UnaryRead<String, Variant>(this.uri){

                public Variant perform(ReadGraph graph) throws DatabaseException {
                    Variable variable = Variables.getVariable((ReadGraph)graph, (String)((String)this.parameter));
                    return variable.getVariantValue(graph);
                }
            }, (Listener)new Listener<Variant>(){

                public void execute(Variant result) {
                    listener.newValue(result);
                }

                public void exception(Throwable t) {
                    LOGGER.error("Error while evaluating variable value", t);
                }

                public boolean isDisposed() {
                    return listener.isDisposed();
                }
            });
        }

        public void modify(Object context, final Variant newValue) {
            Simantics.getSession().asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    Variable variable = Variables.getVariable((ReadGraph)graph, (String)uri);
                    variable.setValue(graph, (Object)newValue);
                }
            });
        }
    }
}

