package org.simantics.simulation.sequences.action;

import org.simantics.databoard.binding.Binding;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.tuple.Tuple0;

public interface ActionContext {
    double time();
    Object get(String variableName, Binding binding);
    void set(String variableName, Object value, Binding binding);
    void scheduleNow(Function1<Tuple0,Object> continuation);
    void scheduleNextStep(Function1<Tuple0,Object> continuation);
    void scheduleAt(double time, Function1<Tuple0,Object> continuation);
    void stop();
}
